#ifndef __CXCOMDEF_H__
#define __CXCOMDEF_H__

/* ------------------------------------------------------------------------
** Constants
** ------------------------------------------------------------------------ */

#ifdef TRUE
#undef TRUE
#endif

#ifdef FALSE
#undef FALSE
#endif

#define TRUE   1   /* Boolean true value. */
#define FALSE  0   /* Boolean false value. */

#define  ON   1    /* On value. */
#define  OFF  0    /* Off value. */

#ifdef _lint
  #define NULL 0
#endif

#ifndef NULL
  #define NULL  0
#endif

/* -----------------------------------------------------------------------
** Standard Types
** ----------------------------------------------------------------------- */

/* The following definitions are the same accross platforms.  This first
** group are the sanctioned types.
*/

typedef  unsigned char      boolean;     /* Boolean value type. */

typedef  unsigned long int  uint32;      /* Unsigned 32 bit value */
typedef  unsigned short     uint16;      /* Unsigned 16 bit value */
typedef  unsigned char      uint8;       /* Unsigned 8  bit value */

typedef  signed long int    int32;       /* Signed 32 bit value */
typedef  signed short       int16;       /* Signed 16 bit value */
typedef  signed char        int8;        /* Signed 8  bit value */

/*
* Basic types
*/
/// class id
typedef uint32 CXCLSID;

/// interface id
typedef uint32 CXIID;

typedef int32 CXRESULT;

// error code
#define NOERROR 0

#define _CXRESULT_TYPEDEF_(value) value

#define CX_S_OK                _CXRESULT_TYPEDEF_(0)
#define CX_E_FAIL				_CXRESULT_TYPEDEF_(1) 
#define CX_E_NOMEMORY			_CXRESULT_TYPEDEF_(2) 
#define CX_E_CLASSNOTSUPPORT   _CXRESULT_TYPEDEF_(3) 

// contants

#define ASSERT_STRING_BUFFER_MAX	64
#define CX_TEST_NAME_LENGTH        40
#define TEST_FIXTURE_NUM_MAX 16

#endif /* __CXCOMDEF_H__ */
