/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __CXTEST_H__
#define __CXTEST_H__


typedef void (*PFNSETUP)(void);
typedef void (*PFNTEARDWON)(void);
typedef void (*PFNRUNTEST)(ITest* pme);

typedef struct __ITestResult ITestResult; 

typedef struct __ITest ITest;

typedef struct __ITestVtbl ITestVtbl;

struct __ITestVtbl
{
    uint32 (* addRef) (ITest* pobj);
    uint32 (* release) (ITest* pobj);
    CXRESULT (*queryInterface)(ITest* pobj, CXCLSID clsid, void ** ppNew);
    char* (*name)(ITest* pobj);
    void (*run)(ITest* pobj, ITestResult* pResult);
    int  (*countTestCases)(ITest* pobj);
    int  (*getChildTestCount)(ITest* pobj);
    ITest* (*getChildTestAt)(ITest* pobj, int index);
    ITest* (*findTest)(ITest* pobj, char *name);
    ITestResult*    (*getTestResult)(ITest* pobj);
    void            (*setTestResult)(ITest* pobj, ITestResult* piTestResult);
};


#define ITest_addRef(pobj)         (*(ITestVtbl**)pobj)->addRef(pobj)
#define ITest_release(pobj)         (*(ITestVtbl**)pobj)->release(pobj)
#define ITest_queryInterface(po,id,ppn) (*((ITestVtbl**)po))->queryInterface(po,id,ppn)
#define ITest_name(pobj)           (*(ITestVtbl**)pobj)->name(pobj)
#define ITest_run(pobj,r)          (*(ITestVtbl**)pobj)->run(pobj,r)
#define ITest_countTestCases(pobj) (*(ITestVtbl**)pobj)->countTestCases(pobj)
#define ITest_getChildTestCount(pobj) (*(ITestVtbl**)pobj)->getChildTestCount(pobj)
#define ITest_getChildTestAt(pobj,i) (*(ITestVtbl**)pobj)->getChildTestAt(pobj,i)
#define ITest_findTest(pobj,n)      (*(ITestVtbl**)pobj)->findTest(pobj,n)

#define ITest_getTestResult(pobj)           (*(ITestVtbl**)pobj)->getTestResult(pobj)
#define ITest_setTestResult(pobj, pResult)  (*(ITestVtbl**)pobj)->setTestResult(pobj,pResult)

#endif /* __CXTEST_H__ */
