/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __CXTESTCASE_H__
#define __CXTESTCASE_H__

typedef struct __ITestCase ITestCase;

typedef struct __ITestCaseVtbl ITestCaseVtbl;

struct __ITestCaseVtbl{
    uint32 (* addRef) (ITestCase* pobj);
    uint32 (* release) (ITestCase* pobj);
    CXRESULT (*queryInterface)(ITestCase* pobj, CXCLSID clsid, void ** ppNew);
    char* (*name)(ITestCase* pobj);
    void (*run)(ITestCase* pobj, ITestResult* pResult);
    int  (*countTestCases)(ITestCase* pobj);
    int  (*getChildTestCount)(ITestCase* pobj);
    ITest* (*getChildTestAt)(ITestCase* pobj, int index);
    ITest* (*findTest)(ITestCase* pobj, char *name);
    ITestResult*    (*getTestResult)(ITestCase* pobj);
    void            (*setTestResult)(ITestCase* pobj, ITestResult* piTestResult);

    CXRESULT (*init)(ITestCase* pobj, char * name, PFNSETUP setup, PFNTEARDWON teardown, PFNRUNTEST runTest);
    void (*setName)(ITestCase* pobj, char* name);
    void (*setRunTest)(ITestCase* pobj,  PFNRUNTEST runTest);       
};

#define ITestCase_addRef(pobj)         (*(ITestCaseVtbl**)pobj)->addRef(pobj)
#define ITestCase_release(pobj)         (*(ITestCaseVtbl**)pobj)->release(pobj)
#define ITestCase_queryInterface(po,id,ppn) (*(ITestCaseVtbl**)po)->queryInterface(po,id,ppn)
#define ITestCase_name(pobj)           (*(ITestCaseVtbl**)pobj)->name(pobj)
#define ITestCase_run(pobj,r)          (*(ITestCaseVtbl**)pobj)->run(pobj,r)
#define ITestCase_countTestCases(pobj) (*(ITestCaseVtbl**)pobj)->countTestCases(pobj)
#define ITestCase_getChildTestCount(pobj) (*(ITestCaseVtbl**)pobj)->getChildTestCount(pobj)
#define ITestCase_getChildTestAt(pobj,i) (*(ITestCaseVtbl**)pobj)->getChildTestAt(pobj,i)
#define ITestCase_findTestCase(pobj,n) (*(ITestCaseVtbl**)pobj)->findTestCase(pobj,n)

#define ITestCase_init(pobj, name, setup, teardown, runTest) (*(ITestCaseVtbl**)pobj)->init(pobj,name, setup, teardown, runTest)
#define ITestCase_setName(pobj, name) (*(ITestCaseVtbl**)pobj)->setName(pobj,name)
#define ITestCase_setRunTest(pobj, runTest) (*(ITestCaseVtbl**)pobj)->setRunTest(pobj,runTest)
#define ITestCase_getTestResult(pobj)           (*(ITestCaseVtbl**)pobj)->getTestResult(pobj)
#define ITestCase_setTestResult(pobj, pResult)  (*(ITestCaseVtbl**)pobj)->setTestResult(pobj,pResult)

CXRESULT 
ITestCase_new(ITestCase** ppobj);

#endif /* __CXTESTCASE_H__ */
