/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __CXTESTLIST_H__
#define __CXTESTLIST_H__

// Double Linked List for ITest

//#include "acttest.h"

#ifdef WIN32
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#endif // WIN32

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct __ITest		ITest;

typedef struct __ITestNode ITestNode;


typedef struct __ITestList ITestList;


typedef struct __ITestListVtbl ITestListVtbl;


struct __ITestListVtbl
{
/// IUnknown interface    

    uint32 (* addRef) (ITestList* pobj);

    uint32 (* release) (ITestList* pobj);

    CXRESULT (*queryInterface)(ITestList* pobj, CXCLSID clsid, void ** ppNew);

    
/// Head/Tail Access

	/// Returns the head element of the list (cannot be empty).
	const ITest* (* getHead)(ITestList *pMe);
	/// Returns the tail element of the list (cannot be empty).
	const ITest* (* getTail)(ITestList *pMe);

/// Operations

	/// removes the element from the head of the list.
	ITest* (* removeHead)(ITestList *pMe, boolean bDataDelete);

	/// removes the element from the tail of the list. 
	ITest* (* removeTail)(ITestList *pMe, boolean bDataDelete);
	
	/// adds an element (or all the elements in another list) to the head of the list (makes a new head).
	ITestNode* (* addHead)(ITestList *pMe, ITest* pItem);

	/// adds an element (or all the elements in another list) to the tail of the list (makes a new tail).
	ITestNode* (* addTail)(ITestList *pMe, ITest* pItem);
	
	/// removes all the elements from this list.
	// bDataDelete = FALSE ̸ Ʈ ͵ ݵ ڰ delete Ѵ.
	void (* removeAll)(ITestList *pMe, boolean bDataDelete);	

/// Iteration

	/// Returns the position of the head element of the list.
	const ITestNode* (* getHeadPosition)(ITestList *pMe);

	/// Returns the position of the tail element of the list.
	const ITestNode* (* getTailPosition)(ITestList *pMe);
	
	/// gets the next element for iterating.
	const ITest* (* getNext)(ITestList *pMe, ITestNode** lppPosition);
	
	/// gets the previous element for iterating.
	const ITest* (* getPrev)(ITestList *pMe, ITestNode** lppPosition);

/// Retrieval/Modification

	/// gets the element at a given position.
	const ITest* (* getAt)(ITestList *pMe, ITestNode* position);

	/// sets the element at a given position.
	void (* SetAt)(ITestList *pMe, ITestNode* pos, ITest* newElement, boolean bDeleteData);
	
	/// removes an element from this list, specified by position.
	void (* removeAt)(ITestList *pMe, ITestNode* position, boolean bDeleteData);
	
/// insertion

	/// inserts a new element before a given position.
	ITestNode* (* insertBefore)(ITestList *pMe, ITestNode* pos, ITest* newElement);

	/// inserts a new element after a given position.
	ITestNode* (* insertAfter)(ITestList *pMe, ITestNode* pos, ITest* newElement);
	
/// Searching

	/// gets the position of an element specified by pointer value.
	const ITestNode* (* find)(ITestList *pMe, ITest* searchValue, ITestNode* startAfter);

	/// gets the position of an element specified by a zero-based index.
	const ITestNode* (* findIndex)(ITestList *pMe, int nIndex);

	/// gets the number of an element specified by pointer value.
	const int (* getNo)(ITestList *pMe, ITest* searchValue, ITestNode* startAfter);
	
/// Status

	/// Returns the number of elements in this list.
	int (* getCount)(ITestList *pMe);
	
	/// Tests for the empty list condition (no elements).
	boolean (* isEmpty)(ITestList *pMe);
};



/// IUnknown interface

        /// add reference
#define ITestList_addRef(po) (*((ITestListVtbl**)po))->addRef(po)

        /// release interface
#define ITestList_release(po) (*((ITestListVtbl**)po))->release(po)

        /// query interface
#define ITestList_queryInterface(po,id,ppn) (*((ITestListVtbl**)po))->queryInterface(po,id,ppn)

/// Operations

	/// removes the element from the head of the list.
#define ITestList_removeHead(pMe, bDataDelete) (*(ITestListVtbl**)pMe)->removeHead(pMe, bDataDelete)

	/// removes the element from the tail of the list. 
#define ITestList_removeTail(pMe, bDataDelete) (*(ITestListVtbl**)pMe)->removeTail(pMe, bDataDelete)
	
	/// adds an element (or all the elements in another list) to the head of the list (makes a new head).
#define ITestList_addHead(pMe, pItem) (*(ITestListVtbl**)pMe)->addHead(pMe, pItem)

	/// adds an element (or all the elements in another list) to the tail of the list (makes a new tail).
#define ITestList_addTail(pMe, pItem) (*(ITestListVtbl**)pMe)->addTail(pMe, pItem)
	
	/// removes all the elements from this list.
	// bDataDelete = FALSE ̸ Ʈ ͵ ݵ ڰ delete Ѵ.
#define ITestList_removeAll(pMe, bDataDelete) (*(ITestListVtbl**)pMe)->removeAll(pMe, bDataDelete)

/// Iteration

	/// Returns the position of the head element of the list.
#define ITestList_getHeadPosition(pMe) (*(ITestListVtbl**)pMe)->getHeadPosition(pMe)

	/// Returns the position of the tail element of the list.
#define ITestList_getTailPosition(pMe) (*(ITestListVtbl**)pMe)->getTailPosition(pMe)
	
	/// gets the next element for iterating.
#define ITestList_getNext(pMe, lppPosition) (*(ITestListVtbl**)pMe)->getNext(pMe, lppPosition)
	
	/// gets the previous element for iterating.
#define ITestList_getPrev(pMe, lppPosition) (*(ITestListVtbl**)pMe)->getPrev(pMe, lppPosition)

/// Retrieval/Modification

	/// gets the element at a given position.
#define ITestList_getAt(pMe, position) (*(ITestListVtbl**)pMe)->getAt(pMe, position)

	/// sets the element at a given position.
#define ITestList_setAt(pMe, pos, newElement, bDeleteData) (*(ITestListVtbl**)pMe)->setAt(pMe, pos, newElement, bDeleteData)
	
	/// removes an element from this list, specified by position.
#define ITestList_removeAt(pMe, position, bDeleteData)(*(ITestListVtbl**)pMe)->removeAt(pMe, position, bDeleteData)(*(ITestListVtbl**)pMe)
	
/// insertion

	/// inserts a new element before a given position.
#define ITestList_insertBefore(pMe, pos, newElement) (*(ITestListVtbl**)pMe)->insertBefore(pMe, pos, newElement) 

	/// inserts a new element after a given position.
#define ITestList_insertAfter(pMe, pos, newElement) (*(ITestListVtbl**)pMe)->insertAfter(pMe, pos, newElement)
	
/// Searching

	/// gets the position of an element specified by pointer value.
#define ITestList_find(pMe, searchValue, startAfter) (*(ITestListVtbl**)pMe)->find(pMe, searchValue, startAfter) 

	/// gets the position of an element specified by a zero-based index.
#define ITestList_findIndex(pMe, nIndex) (*(ITestListVtbl**)pMe)->findIndex(pMe, nIndex) 

	/// gets the number of an element specified by pointer value.
#define ITestList_getNo(pMe, searchValue, startAfter) (*(ITestListVtbl**)pMe)->getNo(pMe, searchValue, startAfter)
	
/// Status

	/// Returns the number of elements in this list.
#define ITestList_getCount(pMe) (*(ITestListVtbl**)pMe)->getCount(pMe)
	
	/// Tests for the empty list condition (no elements).
#define ITestList_isEmpty(pMe) (*(ITestListVtbl**)pMe)->isEmpty(pMe) 


CXRESULT ITestList_new(ITestList** ppobj);
#ifdef	__cplusplus
}
#endif

#endif //  __CXTESTLIST_H__

