/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef	__CXTESTLISTENER_H__
#define	__CXTESTLISTENER_H__


typedef void(*TestListenerStartTestCallBack)(void*,void*);
typedef void(*TestListenerEndTestCallBack)(void*,void*);
typedef void(*TestListenerAddFailureCallBack)(void*,void*,const char*,int,const char*);

typedef struct __ITestListener	ITestListener;

typedef struct __ITestListenerVtbl	ITestListenerVtbl;

struct __ITestListenerVtbl {
    uint32 (* addRef) (ITestListener* pobj);
    uint32 (* release) (ITestListener* pobj);
    CXRESULT (*queryInterface)(ITestListener* pobj, CXCLSID clsid, void ** ppNew);
   
	TestListenerStartTestCallBack startTest;
	TestListenerEndTestCallBack endTest;
	TestListenerAddFailureCallBack addFailure;
};

#define ITestListener_addRef(pobj)         (*(ITestListenerVtbl**)pobj)->addRef(pobj)
#define ITestListener_release(pobj)         (*(ITestListenerVtbl**)pobj)->release(pobj)
#define ITestListener_queryInterface(pobj,id,ppn) (*(ITestListenerVtbl**)pobj)->queryInterface(pobj,id,ppn)

#define ITestListener_startTest(po,test)				(*(ITestListenerVtbl**)po)->startTest(po,test)
#define ITestListener_endTest(po,test)					(*(ITestListenerVtbl**)po)->endTest(po,test)
#define ITestListener_addFailure(po,test,msg,line,file)	(*(ITestListenerVtbl**)po)->addFailure(po,test,msg,line,file)

CXRESULT ITestListener_new(ITestListener** ppobj);

#endif/*__CXTESTLISTENER_H__*/

