/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __CXTESTRUNNERMFC_H__
#define __CXTESTRUNNERMFC_H__



#if defined(_AFXEXT)
#define CX_API __declspec(dllexport)
#else
#define CX_API __declspec(dllimport)
#endif 

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct __ITestRunnerMfc         ITestRunnerMfc;

typedef struct __ITestRunnerMfcVtbl     ITestRunnerMfcVtbl;

struct __ITestRunnerMfcVtbl {
    uint32 (*addRef)(ITestRunnerMfc* po);
    uint32 (*release)(ITestRunnerMfc* po);
    CXRESULT (*queryInterface)(ITestRunnerMfc* pobj, CXCLSID clsid, void ** ppNew);

    void (*start)(ITestRunnerMfc* po);
    void (*addTest)(ITestRunnerMfc* po, ITest* test);
    void (*runTest)(ITestRunnerMfc* po);
    void (*end)(ITestRunnerMfc*po);
    ITest* (*getRootTest)(ITestRunnerMfc*po);
};

#define ITestRunnerMfc_addRef(pobj)         (*(ITestRunnerMfcVtbl**)pobj)->addRef(pobj)
#define ITestRunnerMfc_release(pobj)         (*(ITestRunnerMfcVtbl**)pobj)->release(pobj)
#define ITestRunnerMfc_queryInterface(po,id,ppn) (*((ITestRunnerMfcVtbl**)po))->queryInterface(po,id,ppn)

#define ITestRunnerMfc_start(po)            (*(ITestRunnerMfcVtbl**)po)->start(po)
#define ITestRunnerMfc_addTest(po,test)     (*(ITestRunnerMfcVtbl**)po)->addTest(po,test)
#define ITestRunnerMfc_runTest(po)          (*(ITestRunnerMfcVtbl**)po)->runTest(po)
#define ITestRunnerMfc_end(po)              (*(ITestRunnerMfcVtbl**)po)->end(po)
#define ITestRunnerMfc_getRootTest(po)      (*(ITestRunnerMfcVtbl**)po)->getRootTest(po)

CX_API CXRESULT _ITestRunnerMfc_new(ITestRunnerMfc** ppObj);

#ifdef  __cplusplus
}
#endif

#endif /*  __CXTESTRUNNERMFC_H__ */
