/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "cx.h"

struct __ITestCase {
    ITestCaseVtbl* pvt;
    uint32 m_cRef;
	char name[CX_TEST_NAME_LENGTH];
	void(*runTest)(ITest* pme);
	void(*setUp)(void);
	void(*tearDown)(void);
    uint32 m_dwExtra;
    
    ITestResult* m_piTestResult;
};

CXRESULT 
ITestCase_new(ITestCase** ppobj);

void            
_ITestCase_ctor(ITestCase* pobj, ITestCaseVtbl* pvt);

void 
_ITestCase_initVtbl(ITestCaseVtbl* pvt);

CXRESULT 
_ITestCase_init(ITestCase* pobj, char * name, PFNSETUP setup, PFNTEARDWON teardown, PFNRUNTEST runTest);


uint32         
_ITestCase_addRef(ITestCase* pobj);

uint32          
_ITestCase_release(ITestCase* pobj);

void            
_ITestCase_xtor(ITestCase* pobj);

CXRESULT   
_ITestCase_queryInterface(ITestCase* pobj, CXCLSID clsid, void ** ppNew);

char* 
_ITestCase_name(ITestCase* pobj);

void 
_ITestCase_run(ITestCase* pme,ITestResult* pResult);


int 
_ITestCase_countTestCases(ITestCase* pme);


int 
_ITestCase_getChildTestCount(ITestCase* pme);


ITest* 
_ITestCase_getChildTestAt(ITestCase* pme, int index);


ITest* 
_ITestCase_findTest(ITestCase* pme,char * pszName);


ITestResult* 
_ITestCase_getTestResult(ITestCase* pobj);

void
_ITestCase_setTestResult(ITestCase* pobj, ITestResult* piTestResult);

void
_ITestCase_setName(ITestCase* pobj, char * name);

void
_ITestCase_setRunTest(ITestCase* pobj, PFNRUNTEST runTest);
    
void 
_cx_addFailure(const char *msg, long line, const char *file);


///////////////////////////////////////////////////////////////////////////////
// ITestCase
//static ITestResult* s_piTestResult;
//static ITestCase* s_piTestCase;

CXRESULT 
ITestCase_new(ITestCase** ppobj)
{
    CXRESULT result;
    ITestCase * pme;

    pme = (ITestCase*) cx_malloc(sizeof(ITestCase) + sizeof(ITestCaseVtbl) );

    *ppobj = NULL;

    if(!pme)
    {
        return CX_E_NOMEMORY;
    }
    
    _ITestCase_ctor(pme, (ITestCaseVtbl*)(pme+1));
    result = _ITestCase_init(pme,"", NULL, NULL, NULL);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestCase_xtor(pme);
        cx_free(pme);        
    }

    *ppobj = (ITestCase*)pme;
    
    return result;
    
}

void 
_ITestCase_ctor(ITestCase* pme, ITestCaseVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestCase_initVtbl(pvt);
    }    
}


void 
_ITestCase_initVtbl(ITestCaseVtbl* pvt)
{
    pvt->addRef = _ITestCase_addRef;
    pvt->release = _ITestCase_release;
    pvt->queryInterface = _ITestCase_queryInterface;
    pvt->name = _ITestCase_name;
    pvt->run = _ITestCase_run;
    pvt->countTestCases = _ITestCase_countTestCases;
    pvt->getChildTestCount = _ITestCase_getChildTestCount;
    pvt->getChildTestAt = _ITestCase_getChildTestAt;
    pvt->findTest = _ITestCase_findTest;

    pvt->init = _ITestCase_init;
    pvt->setName = _ITestCase_setName;
    pvt->setRunTest = _ITestCase_setRunTest;

    pvt->getTestResult = _ITestCase_getTestResult;
    pvt->setTestResult = _ITestCase_setTestResult;
}


CXRESULT 
_ITestCase_init(ITestCase* pobj, char * name, PFNSETUP setup, PFNTEARDWON teardown, PFNRUNTEST runTest)
{
    ITestCase * pme;
    pme = (ITestCase *) pobj;

    cx_strncpy(pme->name, name, CX_TEST_NAME_LENGTH);
    pme->setUp = setup;
    pme->tearDown = teardown;
    pme->runTest = runTest;
    
    return CX_S_OK;
}


uint32 
_ITestCase_addRef(ITestCase* pobj)
{
    ITestCase* pme = (ITestCase*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestCase_release(ITestCase* pobj)
{
    ITestCase* pme;
    uint32 cRef;

    pme = (ITestCase*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestCase_xtor(pme);
        cx_free(pme);
    }
    
    return cRef;
}


void 
_ITestCase_xtor(ITestCase* pme)
{
}


CXRESULT 
_ITestCase_queryInterface(ITestCase* pobj, CXCLSID clsid, void ** ppNew)
{
    CXRESULT result;

    result = CX_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == CXIID_UNKNOWN  || clsid == CXCLSID_UNKNOWN ||
        clsid == CXIID_TEST     || clsid == CXCLSID_TEST ||
        clsid == CXIID_TESTCASE || clsid == CXCLSID_TESTCASE)
    {
        *ppNew = pobj;
        _ITestCase_addRef(pobj);
        result = CX_S_OK;
    }
    
    return result;
}

char* 
_ITestCase_name(ITestCase* pobj)
{
    ITestCase *pme;
    pme = (ITestCase*) pobj;

    return pme->name;
}

void 
_ITestCase_run(ITestCase* pme,ITestResult* pResult)
{
	ITestResult_startTest(pResult, (ITest*)pme);
	if (pme->setUp) {
		pme->setUp();
	}
	if (pme->runTest) {
		//ITestResult* wr =s_piTestResult;	/*push*/
		//ITestCase* ws = s_piTestCase;	/*push*/
		//s_piTestResult = pResult;
		//s_piTestCase = pme;
		ITestResult* wr = ITestCase_getTestResult(pme); 
		ITestCase_setTestResult(pme, pResult); // push
		pme->runTest((ITest*) pme);
        ITestCase_setTestResult(pme, wr); // pop 
		//s_piTestResult = wr;	/*pop*/
		//s_piTestCase = ws;	/*pop*/
	}
	if (pme->tearDown) {
		pme->tearDown();
	}
	ITestResult_endTest(pResult, (ITest*)pme);
}


int 
_ITestCase_countTestCases(ITestCase* pme)
{
	return 1;
}


int 
_ITestCase_getChildTestCount(ITestCase* pme)
{
	return 0;
}


ITest* 
_ITestCase_getChildTestAt(ITestCase* pme, int index)
{
	return NULL;
}


ITest* 
_ITestCase_findTest(ITestCase* pme,char * pszName)
{
    char * pszTestName;

    pszTestName = _ITestCase_name(pme);
    if ( cx_strcmp(pszTestName, pszName) == 0)
    {
        return (ITest*) pme;
    }

    return NULL;
}


ITestResult* 
_ITestCase_getTestResult(ITestCase* pobj)
{
    ITestCase *pme;
    pme = (ITestCase*) pobj;

    return pme->m_piTestResult;
}


void
_ITestCase_setTestResult(ITestCase* pobj, ITestResult* piTestResult)
{
    ITestCase *pme;
    pme = (ITestCase*) pobj;

    pme->m_piTestResult = piTestResult;
}


void
_ITestCase_setName(ITestCase* pobj, char * name)
{
    ITestCase *pme;
    pme = (ITestCase*) pobj;
    
    cx_strncpy(pme->name,name, CX_TEST_NAME_LENGTH);
}


void
_ITestCase_setRunTest(ITestCase* pobj, PFNRUNTEST runTest)
{
    ITestCase *pme;
    pme = (ITestCase*) pobj;

    pme->runTest = runTest;
}

    
void cx_addFailure(ITest* pme, const char *msg, long line, const char *file)
{	
    ITest* piTest;
    ITestResult* piTestResult;
    
    piTest = (ITest*) pme;
    piTestResult = ITest_getTestResult(piTest);
	ITestResult_addFailure(piTestResult, piTest, (char*)msg, line, (char*)file);
}

