/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "cx.h"
#include "cxtestfixture.h"

struct __ITestFixture {
	ITestFixtureVtbl* pvt;
    uint32 m_cRef;
	char name[CX_TEST_NAME_LENGTH];
	void(*test)(ITest* pme);
};


CXRESULT 
_ITestFixture_new(ITestFixture** ppobj);


void            
_ITestFixture_ctor(ITestFixture* pobj, ITestFixtureVtbl* pvt);


void 
_ITestFixture_initVtbl(ITestFixtureVtbl* pvt);


CXRESULT 
_ITestFixture_init(ITestFixture* pobj, char* name, PFNTEST test);


uint32         
_ITestFixture_addRef(ITestFixture* pobj);


uint32          
_ITestFixture_release(ITestFixture* pobj);


void            
_ITestFixture_xtor(ITestFixture* pobj);


CXRESULT   
_ITestFixture_queryInterface(ITestFixture* pobj, CXCLSID clsid, void ** ppNew);


char*    
_ITestFixture_name(ITestFixture* pme);


PFNTEST  
_ITestFixture_test(ITestFixture* pme);

// ----


CXRESULT 
_ITestFixture_new(ITestFixture** ppobj)
{
    CXRESULT result;
    ITestFixture * pme;

    pme = (ITestFixture*) cx_malloc(sizeof(ITestFixture) + sizeof(ITestFixtureVtbl) );

    *ppobj = NULL;

    if(!pme)
    {
        return CX_E_NOMEMORY;
    }
    
    _ITestFixture_ctor(pme, (ITestFixtureVtbl*)(pme+1));
    result = _ITestFixture_init(pme,"", NULL);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestFixture_xtor(pme);
        cx_free(pme);        
    }

    *ppobj = (ITestFixture*)pme;
    
    return result;
    
}

void 
_ITestFixture_ctor(ITestFixture* pme, ITestFixtureVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestFixture_initVtbl(pvt);
    }    
}


void 
_ITestFixture_initVtbl(ITestFixtureVtbl* pvt)
{
    pvt->addRef = _ITestFixture_addRef;
    pvt->release = _ITestFixture_release;
    pvt->queryInterface = _ITestFixture_queryInterface;

    pvt->init = _ITestFixture_init;
    pvt->name = _ITestFixture_name;
    pvt->test = _ITestFixture_test;
}


CXRESULT 
_ITestFixture_init(ITestFixture* pobj, char* name, PFNTEST test)
{
    ITestFixture * pme;
    pme = (ITestFixture *) pobj;

	cx_strncpy(pme->name, name,CX_TEST_NAME_LENGTH);
	pme->test = test;
    
    return CX_S_OK;
}


uint32 
_ITestFixture_addRef(ITestFixture* pobj)
{
    ITestFixture* pme = (ITestFixture*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestFixture_release(ITestFixture* pobj)
{
    ITestFixture* pme;
    uint32 cRef;

    pme = (ITestFixture*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestFixture_xtor(pme);
        cx_free(pme);
    }
    
    return cRef;
}


void 
_ITestFixture_xtor(ITestFixture* pme)
{
}


CXRESULT 
_ITestFixture_queryInterface(ITestFixture* pobj, CXCLSID clsid, void ** ppNew)
{
    CXRESULT result;

    result = CX_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == CXCLSID_UNKNOWN ||clsid == CXIID_UNKNOWN ||
        clsid == CXCLSID_TESTFIXTURE || clsid == CXIID_TESTFIXTURE)
    {
        *ppNew = pobj;
        _ITestFixture_addRef(pobj);
        result = CX_S_OK;
    }
    
    return result;
}

char* _ITestFixture_name(ITestFixture* pme)
{
	return pme->name;
}

PFNTEST  _ITestFixture_test(ITestFixture* pme)
{
	return pme->test;
}


