/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "cx.h"
#include "cxtestrepeat.h"

struct __ITestRepeat {
	ITestRepeatVtbl* pvt;
	ITest* test;
    uint32 m_cRef;
	int timesRepeat;
};


CXRESULT 
_ITestRepeat_new(ITestRepeat** ppobj);

void            
_ITestRepeat_ctor(ITestRepeat* pobj, ITestRepeatVtbl* pvt);

void 
_ITestRepeat_initVtbl(ITestRepeatVtbl* pvt);

CXRESULT 
_ITestRepeat_init(ITestRepeat* pobj, ITest* test, int timesRepeat);

uint32         
_ITestRepeat_addRef(ITestRepeat* pobj);

uint32          
_ITestRepeat_release(ITestRepeat* pobj);

void            
_ITestRepeat_xtor(ITestRepeat* pobj);

CXRESULT   
_ITestRepeat_queryInterface(ITestRepeat* pobj, CXCLSID clsid, void ** ppNew);

char* 
_ITestRepeat_name(ITestRepeat* pobj);

void 
_ITestRepeat_run(ITestRepeat* pme,ITestResult* pResult);


int 
_ITestRepeat_countTestCases(ITestRepeat* pme);


int 
_ITestRepeat_getChildTestCount(ITestRepeat* pme);


ITest* 
_ITestRepeat_getChildTestAt(ITestRepeat* pme, int index);


ITest* 
_ITestRepeat_findTest(ITestRepeat* pme,char * pszName);


char* 
_ITestRepeat_name(ITestRepeat* pobj);


void 
_ITestRepeat_run(ITestRepeat* pme,ITestResult* pResult);


int 
_ITestRepeat_countTestCases(ITestRepeat* pme);


int 
_ITestRepeat_getChildTestCount(ITestRepeat* pme);


ITest* 
_ITestRepeat_getChildTestAt(ITestRepeat* pme, int index);


ITest* 
_ITestRepeat_findTest(ITestRepeat* pme,char * pszName);


CXRESULT 
_ITestRepeat_new(ITestRepeat** ppobj)
{
    CXRESULT result;
    ITestRepeat * pme;

    pme = (ITestRepeat*) cx_malloc(sizeof(ITestRepeat) + sizeof(ITestRepeatVtbl) );

    *ppobj = NULL;

    if(!pme)
    {
        return CX_E_NOMEMORY;
    }
    
    _ITestRepeat_ctor(pme, (ITestRepeatVtbl*)(pme+1));
    result = _ITestRepeat_init(pme,NULL,0);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestRepeat_xtor(pme);
        cx_free(pme);        
    }

    *ppobj = (ITestRepeat*)pme;
    
    return result;
    
}

void 
_ITestRepeat_ctor(ITestRepeat* pme, ITestRepeatVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestRepeat_initVtbl(pvt);
    }    
}


void 
_ITestRepeat_initVtbl(ITestRepeatVtbl* pvt)
{
    pvt->addRef = _ITestRepeat_addRef;
    pvt->release = _ITestRepeat_release;
    pvt->queryInterface = _ITestRepeat_queryInterface;
    pvt->name = _ITestRepeat_name;
    pvt->run = _ITestRepeat_run;
    pvt->countTestCases = _ITestRepeat_countTestCases;
    pvt->getChildTestCount = _ITestRepeat_countTestCases;
    pvt->getChildTestAt = _ITestRepeat_getChildTestAt;
    pvt->findTest = _ITestRepeat_findTest;

    pvt->init = _ITestRepeat_init;
}


CXRESULT 
_ITestRepeat_init(ITestRepeat* pobj, ITest* test, int timesRepeat)
{
    ITestRepeat * pme;
    pme = (ITestRepeat *) pobj;

    pme->test = test;
    pme->timesRepeat = timesRepeat;
        
    return CX_S_OK;
}


uint32 
_ITestRepeat_addRef(ITestRepeat* pobj)
{
    ITestRepeat* pme = (ITestRepeat*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestRepeat_release(ITestRepeat* pobj)
{
    ITestRepeat* pme;
    uint32 cRef;

    pme = (ITestRepeat*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestRepeat_xtor(pme);
        cx_free(pme);
    }
    
    return cRef;
}


void 
_ITestRepeat_xtor(ITestRepeat* pme)
{
}


CXRESULT 
_ITestRepeat_queryInterface(ITestRepeat* pobj, CXCLSID clsid, void ** ppNew)
{
    CXRESULT result;

    result = CX_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == CXCLSID_UNKNOWN ||
        clsid == CXCLSID_TEST ||
        clsid == CXCLSID_TESTREPEAT)
    {
        *ppNew = pobj;
        _ITestRepeat_addRef(pobj);
        result = CX_S_OK;
    }
    
    return result;
}

//
char* 
_ITestRepeat_name(ITestRepeat* pobj)
{
    ITestRepeat *pme;
    pme = (ITestRepeat*) pobj;

    return ITest_name(pme->test);
}

void 
_ITestRepeat_run(ITestRepeat* pme,ITestResult* pResult)
{
	int i;
	ITest* test = pme->test;
	for (i=0; i<pme->timesRepeat; i++) {
		ITest_run(test, pResult);
	}
}


int 
_ITestRepeat_countTestCases(ITestRepeat* pme)
{
	return ITest_countTestCases(pme->test) * pme->timesRepeat;
}


int 
_ITestRepeat_getChildTestCount(ITestRepeat* pme)
{
	return 0;
}


ITest* 
_ITestRepeat_getChildTestAt(ITestRepeat* pme, int index)
{
	return NULL;
}


ITest* 
_ITestRepeat_findTest(ITestRepeat* pme,char * pszName)
{
    char * pszTestName;

    pszTestName = _ITestRepeat_name(pme);
    if ( cx_strcmp(pszTestName, pszName) == 0)
    {
        return (ITest*) pme;
    }

    return NULL;
}

