/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "cx.h"
#include "cxtestresult.h"

struct __ITestResult {
	ITestResultVtbl* pvt;
    uint32    m_cRef;
	int runCount;
	int failureCount;
	ITestListener* listener;
};

CXRESULT 
_ITestResult_new(ITestResult** ppobj);

void 
_ITestResult_ctor(ITestResult* pme, ITestResultVtbl* pvt);



void 
_ITestResult_initVtbl(ITestResultVtbl* pvt);

CXRESULT 
_ITestResult_init(ITestResult* pobj, ITestListener* piTestListener);

uint32 
_ITestResult_addRef(ITestResult* pobj);


uint32 
_ITestResult_release(ITestResult* pobj);


void 
_ITestResult_xtor(ITestResult* pme);


CXRESULT 
_ITestResult_queryInterface(ITestResult* pobj, CXCLSID clsid, void ** ppNew);



void 
_ITestResult_startTest(ITestResult* pme,ITest* test);

void 
_ITestResult_endTest(ITestResult* pme,ITest* test);

void 
_ITestResult_addFailure(ITestResult* pme,ITest* test,const char* msg,int line,const char* file);

int
_ITestResult_getFailureCount(ITestResult* pme);

int
_ITestResult_getRunCount(ITestResult* pme);
///////////////////////////////////////////////////////////////////////////////
// ITestResult

CXRESULT 
_ITestResult_new(ITestResult** ppobj)
{
    CXRESULT result;
    ITestResult *pme;

    pme = cx_malloc(sizeof(ITestResult)+sizeof(ITestResultVtbl));

    if(!pme)
    {
        return CX_E_NOMEMORY;
    }

    _ITestResult_ctor(pme, (ITestResultVtbl*)(pme+1));    
    result = _ITestResult_init(pme,NULL);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestResult_xtor(pme);
        cx_free(pme);        
    }

    *ppobj = (ITestResult*)pme;
    
    return result;
    
}

void 
_ITestResult_ctor(ITestResult* pme, ITestResultVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestResult_initVtbl(pvt);
    }    
}


void 
_ITestResult_initVtbl(ITestResultVtbl* pvt)
{
    pvt->addRef = _ITestResult_addRef;
    pvt->release = _ITestResult_release;
    pvt->queryInterface = _ITestResult_queryInterface;

    pvt->init = _ITestResult_init;
    pvt->startTest = _ITestResult_startTest;
    pvt->endTest = _ITestResult_endTest;
    pvt->addFailure = _ITestResult_addFailure;

    pvt->getFailureCount = _ITestResult_getFailureCount;
    pvt->getRunCount = _ITestResult_getRunCount;
}

CXRESULT 
_ITestResult_init(ITestResult* pobj, ITestListener* piTestListener)
{
    ITestResult * pme;
    pme = (ITestResult *) pobj;

	pme->runCount = 0;
	pme->failureCount = 0;	
    if(piTestListener)
    {
        pme->listener = piTestListener;
        ITestListener_addRef(piTestListener);
    }
    else
    {
        pme->listener = NULL;
    }

    
    return CX_S_OK;
}


uint32 
_ITestResult_addRef(ITestResult* pobj)
{
    ITestResult* pme = (ITestResult*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestResult_release(ITestResult* pobj)
{
    ITestResult* pme;
    uint32 cRef;

    pme = (ITestResult*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestResult_xtor(pme);
        cx_free(pme);
    }
    
    return cRef;
}


void 
_ITestResult_xtor(ITestResult* pme)
{
    if(pme->listener)
    {
        ITestListener_release(pme->listener);
    }
}


CXRESULT 
_ITestResult_queryInterface(ITestResult* pobj, CXCLSID clsid, void ** ppNew)
{
    CXRESULT result;

    result = CX_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == CXCLSID_UNKNOWN ||
        clsid == CXCLSID_TESTRESULT)
    {
        *ppNew = pobj;
        _ITestResult_addRef(pobj);
        result = CX_S_OK;
    }
    
    return result;
}


void _ITestResult_startTest(ITestResult* pme,ITest* test)
{
	pme->runCount++;
	if (pme->listener) {
		ITestListener_startTest(pme->listener, test);
	}
}

void _ITestResult_endTest(ITestResult* pme,ITest* test)
{
	if (pme->listener) {
		ITestListener_endTest(pme->listener, test);
	}
}

void _ITestResult_addFailure(ITestResult* pme,ITest* test,const char* msg,int line,const char* file)
{
	pme->failureCount++;
	if (pme->listener) {
		ITestListener_addFailure(pme->listener, test, msg, line, file);
	}
}

int
_ITestResult_getFailureCount(ITestResult* pme)
{
    return pme->failureCount;
}

int
_ITestResult_getRunCount(ITestResult* pme)
{
    return pme->runCount;
}



