#include "act.h"
#include "counter.h"

CounterRef counterRef;

static void setUp(void)
{
	counterRef = Counter_counter();
}

static void tearDown(void)
{
	Counter_dealloc(counterRef);
}

static void testInit(void)
{
	ACT_TEST_ASSERT_EQUAL_INT(0, Counter_value(counterRef));
}

static void testSetValue(void)
{
	Counter_setValue(counterRef,1);
	ACT_TEST_ASSERT_EQUAL_INT(1, Counter_value(counterRef));

	Counter_setValue(counterRef,-1);
	ACT_TEST_ASSERT_EQUAL_INT(-1, Counter_value(counterRef));
}

static void testInc(void)
{
	Counter_inc(counterRef);	
	ACT_TEST_ASSERT_EQUAL_INT(1, Counter_value(counterRef));

	Counter_inc(counterRef);	
	ACT_TEST_ASSERT_EQUAL_INT(2, Counter_value(counterRef));
}

static void testDec(void)
{
	Counter_dec(counterRef);
	ACT_TEST_ASSERT_EQUAL_INT(-1, Counter_value(counterRef));

	Counter_dec(counterRef);
	ACT_TEST_ASSERT_EQUAL_INT(-2, Counter_value(counterRef));
}

static void testClr(void)
{
	Counter_inc(counterRef);
	ACT_TEST_ASSERT_EQUAL_INT(1, Counter_value(counterRef));

	Counter_clr(counterRef);
	ACT_TEST_ASSERT_EQUAL_INT(0, Counter_value(counterRef));
}

ITest* CounterTest_tests(void)
{
	/*
	EMB_UNIT_TESTFIXTURES(fixtures) {
		new_TestFixture("testInit",testInit),
		new_TestFixture("testSetValue",testSetValue),
		new_TestFixture("testInc",testInc),
		new_TestFixture("testDec",testDec),
		new_TestFixture("testClr",testClr),
	};
	EMB_UNIT_TESTCALLER(CounterTest,"CounterTest",setUp,tearDown,fixtures);

	return (Test*)&CounterTest;
	*/
	static ITestCaller CounterTest;
	static ITestFixture fixture1;
	static ITestFixture fixture2;
	static ITestFixture fixture3;
	static ITestFixture fixture4;
	static ITestFixture fixture5;

	ITestCaller_Ctor(&CounterTest,"CounterTest",setUp,tearDown);
		ITestFixture_Ctor(&fixture1, "testInit",testInit);
		ITestFixture_Ctor(&fixture2, "testSetValue", testSetValue);
		ITestFixture_Ctor(&fixture3, "testInc", testInc);
		ITestFixture_Ctor(&fixture4, "testDec", testDec);
		ITestFixture_Ctor(&fixture5, "testClr", testClr);

	ITestCaller_AddTestFixture(&CounterTest,&fixture1);
	ITestCaller_AddTestFixture(&CounterTest,&fixture2);
	ITestCaller_AddTestFixture(&CounterTest,&fixture3);
	ITestCaller_AddTestFixture(&CounterTest,&fixture4);
	ITestCaller_AddTestFixture(&CounterTest,&fixture5);

	return (ITest*)&CounterTest;
}
