#include "act.h"
#include "actMockTestCase.h"

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testRepeatedOnce(void)
{
	IRepeatedTest test;
	ITestResult result;

	IRepeatedTest_Ctor(&test, (ITest*)actMockTestCase_case(),1);
	ITestResult_Ctor(&result, NULL);

	ITest_run(&test, &result);

	ACT_TEST_ASSERT_EQUAL_INT(1, result.runCount);
	ACT_TEST_ASSERT_EQUAL_INT(1, ITest_countTestCases(&test));
}

static void testRepeatedMoreThanOnce(void)
{
	IRepeatedTest test;
	ITestResult result;

	IRepeatedTest_Ctor(&test, (ITest*)actMockTestCase_case(),100);
	ITestResult_Ctor(&result, NULL);

	ITest_run(&test, &result);

	ACT_TEST_ASSERT_EQUAL_INT(100, result.runCount);
	ACT_TEST_ASSERT_EQUAL_INT(100, ITest_countTestCases(&test));
}

static void testRepeatedZero(void)
{
	IRepeatedTest test;
	ITestResult result;

	IRepeatedTest_Ctor(&test, (ITest*)actMockTestCase_case(),0);
	ITestResult_Ctor(&result, NULL);

	ITest_run(&test, &result);

	ACT_TEST_ASSERT_EQUAL_INT(0, result.runCount);
	ACT_TEST_ASSERT_EQUAL_INT(0, ITest_countTestCases(&test));
}

ITest* RepeatedTestTest_tests(void)
{
	ACT_UNIT_TESTCALLER_CTOR(RepeatedTestTest,"RepeatedTestTest",setUp,tearDown);
		
		ACT_UNIT_ADD_FIXTURE(&RepeatedTestTest,"testRepeatedOnce",testRepeatedOnce);
		ACT_UNIT_ADD_FIXTURE(&RepeatedTestTest,"testRepeatedMoreThanOnce",testRepeatedMoreThanOnce);
		ACT_UNIT_ADD_FIXTURE(&RepeatedTestTest,"testRepeatedZero",testRepeatedZero);

	return (ITest*)&RepeatedTestTest;
}
