
#ifndef	__ACTTESTCALLER_H__
#define	__ACTTESTCALLER_H__

typedef void(*PFNTEST)(void);

typedef struct __ITestFixture	ITestFixture;

typedef struct __ITestFixtureVtbl ITestFixtureVtbl;

struct __ITestFixtureVtbl {
	char*	(*name)(ITestFixture* po);
	PFNTEST (*test)(ITestFixture* po);
};

struct __ITestFixture {
	ITestFixtureVtbl* pvt;
	char name[TEST_NAME_STRING_BUFFER_MAX];
	void(*test)(void);
};

#define ITestFixture_name(p) (*(ITestFixtureVtbl**)p)->name(p)
#define ITestFixture_test(p) (*(ITestFixtureVtbl**)p)->test(p)

ITestFixture* ITestFixture_Ctor(ITestFixture* pme, char* name, PFNTEST test);

typedef struct __ITestCaller		ITestCaller;
typedef struct __ITestCallerVtbl	ITestCallerVtbl;

struct __ITestCallerVtbl {
	ITestVtbl super_;
	void (*AddTestFixture)(ITestCaller* pme, ITestFixture* fixture);
};

struct __ITestCaller {
	ITestCallerVtbl* pvt;
	char name[TEST_NAME_STRING_BUFFER_MAX];
	void(*setUp)(void);
	void(*tearDown)(void);
	int numberOfFixtuers;
	ITestFixture * fixtures[TEST_FIXTURE_NUM_MAX];
};

#define ITestCaller_AddTestFixture(pme, fixture) (*(ITestCallerVtbl**)pme)->AddTestFixture(pme, fixture)

ITestCaller* ITestCaller_Ctor(ITestCaller* pme, char * name, PFNSETUP setup, PFNTEARDWON tdw);

#endif/*__ACTTESTCALLER_H__*/
