#include "actConfig.h"
#include "actStdlib.h"
#include "actAssertImpl.h"

void ACT_assertImplementationInt(int expected,int actual, long line, const char *file)
{
	char buffer[32];	/*"exp -2147483647 was -2147483647"*/
	char numbuf[12];	/*32bit int decimal maximum column is 11 (-2147483647~2147483647)*/

	ACT_strcpy(buffer, "exp ");

	{	ACT_itoa(expected, numbuf, 10);
		ACT_strncat(buffer, numbuf, 11);	}

	ACT_strcat(buffer, " was ");

	{	ACT_itoa(actual, numbuf, 10);
		ACT_strncat(buffer, numbuf, 11);	}

	ACT_addFailure(buffer, line, file);
}

void ACT_assertImplementationCStr(const char *expected,const char *actual, long line, const char *file)
{
	char buffer[ASSERT_STRING_BUFFER_MAX];
	#define exp_act_limit ((ASSERT_STRING_BUFFER_MAX-11-1)/2)/*	"exp'' was''" = 11 byte	*/
	int el;
	int al;

	if (expected) {
		el = ACT_strlen(expected);
	} else {
		el = 4;
		expected = "null";
	}

	if (actual) {
		al = ACT_strlen(actual);
	} else {
		al = 4;
		actual = "null";
	}
	if (el > exp_act_limit) {
		if (al > exp_act_limit) {
			al = exp_act_limit;
			el = exp_act_limit;
		} else {
			int w = exp_act_limit + (exp_act_limit - al);
			if (el > w) {
				el = w;
			}
		}
	} else {
		int w = exp_act_limit + (exp_act_limit - el);
		if (al > w) {
			al = w;
		}
	}
	ACT_strcpy(buffer, "exp \"");
	ACT_strncat(buffer, expected, el);
	ACT_strcat(buffer, "\" was \"");
	ACT_strncat(buffer, actual, al);
	ACT_strcat(buffer, "\"");

	ACT_addFailure(buffer, line, file);
}
