#include "actConfig.h"
#include "actStdlib.h"
#include "actAssertImpl.h"

void act_assertImplementationInt(int expected,int actual, long line, const char *file)
{
	char buffer[32];	/*"exp -2147483647 was -2147483647"*/
	char numbuf[12];	/*32bit int decimal maximum column is 11 (-2147483647~2147483647)*/

	act_strcpy(buffer, "exp ");

	{	act_itoa(expected, numbuf, 10);
		act_strncat(buffer, numbuf, 11);	}

	act_strcat(buffer, " was ");

	{	act_itoa(actual, numbuf, 10);
		act_strncat(buffer, numbuf, 11);	}

	act_addFailure(buffer, line, file);
}

void act_assertImplementationCStr(const char *expected,const char *actual, long line, const char *file)
{
	char buffer[ASSERT_STRING_BUFFER_MAX];
	#define exp_act_limit ((ASSERT_STRING_BUFFER_MAX-11-1)/2)/*	"exp'' was''" = 11 byte	*/
	int el;
	int al;

	if (expected) {
		el = act_strlen(expected);
	} else {
		el = 4;
		expected = "null";
	}

	if (actual) {
		al = act_strlen(actual);
	} else {
		al = 4;
		actual = "null";
	}
	if (el > exp_act_limit) {
		if (al > exp_act_limit) {
			al = exp_act_limit;
			el = exp_act_limit;
		} else {
			int w = exp_act_limit + (exp_act_limit - al);
			if (el > w) {
				el = w;
			}
		}
	} else {
		int w = exp_act_limit + (exp_act_limit - el);
		if (al > w) {
			al = w;
		}
	}
	act_strcpy(buffer, "exp \"");
	act_strncat(buffer, expected, el);
	act_strcat(buffer, "\" was \"");
	act_strncat(buffer, actual, al);
	act_strcat(buffer, "\"");

	act_addFailure(buffer, line, file);
}
