#include "act.h"
#include "actTests.h"

#ifdef ACT_TESTRESULT_TESTS

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testTestResult_result(void)
{
    ITestResult result;
    ITestResult_Ctor(&result,NULL);
    
    ACT_TEST_ASSERT_EQUAL_INT(0, result.runCount);
    ACT_TEST_ASSERT_EQUAL_INT(0, result.failureCount);
}

static void testTestResult_startTest(void)
{
    ITestResult result;
    ITestResult_Ctor(&result,NULL);
    
    ITestResult_startTest(&result,NULL);
    
    ACT_TEST_ASSERT_EQUAL_INT(1, result.runCount);
    ACT_TEST_ASSERT_EQUAL_INT(0, result.failureCount);
}

static void testTestResult_endTest(void)
{
    ITestResult result;
    ITestResult_Ctor(&result,NULL);
    
    ITestResult_endTest(&result,NULL);
    
    ACT_TEST_ASSERT_EQUAL_INT(0, result.runCount);
    ACT_TEST_ASSERT_EQUAL_INT(0, result.failureCount);
}

static void testTestResult_addFailure(void)
{
    ITestResult result;
    ITestResult_Ctor(&result,NULL);
    
    ITestResult_addFailure(&result,NULL,"",0,"");
    
    ACT_TEST_ASSERT_EQUAL_INT(0, result.runCount);
    ACT_TEST_ASSERT_EQUAL_INT(1, result.failureCount);
}

ITest* TestResultTest_tests(void)
{
    ACT_TESTCALLER_NEW(pTestResultTest,"TestResultTest",setUp,tearDown);

        ACT_ADD_FIXTURE(pTestResultTest,"testTestResult_result",testTestResult_result);
        ACT_ADD_FIXTURE(pTestResultTest,"testTestResult_startTest",testTestResult_startTest);
        ACT_ADD_FIXTURE(pTestResultTest,"testTestResult_endTest",testTestResult_endTest);
        ACT_ADD_FIXTURE(pTestResultTest,"testTestResult_addFailure",testTestResult_addFailure);
    
    return (ITest*)pTestResultTest;
}
#endif // def ACT_TESTRESULT_TESTS
