// MyFormView.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "MyFormView.h"
#include	"TestDlg.h"
#include	"MyDialog.h"
#include	"MyPropertySheet.h"
#include	"MyWizard.h"
#include	"MaxMaxDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyFormView

IMPLEMENT_DYNCREATE(CMyFormView, cdxCDynamicFormView)

CMyFormView::CMyFormView()
:	cdxCDynamicFormView(CMyFormView::IDD, fdAll,flAntiFlicker)
{
	m_pSheet	=	NULL;
	m_pDlg	=	NULL;
	//{{AFX_DATA_INIT(CMyFormView)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CMyFormView::~CMyFormView()
{
	if(m_pSheet)
	{
		m_pSheet->DestroyWindow();
		delete m_pSheet;
	}
	if(m_pDlg)
	{
		m_pDlg->DestroyWindow();
		delete m_pDlg;
	}
}

void CMyFormView::DoDataExchange(CDataExchange* pDX)
{
	cdxCDynamicFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyFormView)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMyFormView, cdxCDynamicFormView)
	//{{AFX_MSG_MAP(CMyFormView)
	ON_BN_CLICKED(IDC_DIALOG, OnDialog)
	ON_BN_CLICKED(IDC_DIALOG_MODELESS, OnDialogModeless)
	ON_BN_CLICKED(IDC_MODELESS_SHEET, OnModelessSheet)
	ON_BN_CLICKED(IDC_SHEET, OnSheet)
	ON_BN_CLICKED(IDC_WIZARD, OnWizard)
	ON_BN_CLICKED(IDC_ROBERTO, OnRoberto)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DYNAMIC_MAP(CMyFormView,cdxCDynamicFormView)
	DYNAMIC_MAP_ENTRY(IDC_DIALOG,				mdRelative,mdRelative)
	DYNAMIC_MAP_ENTRY(IDC_DIALOG_MODELESS,	mdRelative,mdRelative)
	DYNAMIC_MAP_ENTRY(IDC_SHEET,				mdRelative,mdRelative)
	DYNAMIC_MAP_ENTRY(IDC_MODELESS_SHEET,	mdRelative,mdRelative)
	DYNAMIC_MAP_ENTRY(IDC_WIZARD,				mdRelative,mdRelative)
	DYNAMIC_MAP_ENTRY(IDC_ROBERTO,			mdRelative,mdRelative)
	DYNAMIC_MAP_ENTRY(IDC_BOX,					mdResize,mdResize)
	DYNAMIC_MAP_ENTRY(IDC_HEADER,				mdResize,mdRelative)
END_DYNAMIC_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyFormView diagnostics

#ifdef _DEBUG
void CMyFormView::AssertValid() const
{
	cdxCDynamicFormView::AssertValid();
}

void CMyFormView::Dump(CDumpContext& dc) const
{
	cdxCDynamicFormView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMyFormView message handlers

void CMyFormView::OnDialog() 
{
	CTestDlg	dlg(this);
	dlg.DoModal();
}

void CMyFormView::OnDialogModeless() 
{
	if(m_pDlg)
	{
		BOOL	bWasShown	=	::IsWindow(m_pDlg->m_hWnd) && m_pDlg->IsWindowVisible();

		m_pDlg->DestroyWindow();
		delete m_pDlg;
		m_pDlg	=	NULL;

		if(bWasShown)
			return;
	}
	
	m_pDlg	=	new CMyDialog(this);
	VERIFY( m_pDlg->Create(CMyDialog::IDD,this) );
	m_pDlg->ShowWindow(SW_SHOW);

}

void CMyFormView::OnModelessSheet() 
{
	if(m_pSheet)
	{
		BOOL	bWasShown	=	::IsWindow(m_pSheet->m_hWnd) && m_pSheet->IsWindowVisible();

		m_pSheet->DestroyWindow();
		delete m_pSheet;
		m_pSheet	=	NULL;

		if(bWasShown)
			return;
	}
	
	m_pSheet	=	new CMyPropertySheet(this);
	VERIFY( m_pSheet->Create() );
}

void CMyFormView::OnSheet() 
{
	CMyPropertySheet	sheet(this);
	sheet.DoModal();
}

void CMyFormView::OnWizard() 
{
	CMyWizard	wiz;
	wiz.DoModal();
}

void CMyFormView::OnRoberto() 
{
	CMaxMaxDlg	dlg;
	dlg.DoModal();
}
