#include "act.h"
#include "counter.h"

Counter* counterRef;

static void setUp(void)
{
	counterRef = Counter_New();
}

static void tearDown(void)
{
	Counter_Delete(counterRef);
}

static void testInit(void)
{
	ACT_TEST_ASSERT_EQUAL_INT(0, Counter_GetValue(counterRef));
}

static void testSetValue(void)
{
	Counter_SetValue(counterRef,1);
	ACT_TEST_ASSERT_EQUAL_INT(1, Counter_GetValue(counterRef));

	Counter_SetValue(counterRef,-1);
	ACT_TEST_ASSERT_EQUAL_INT(-1, Counter_GetValue(counterRef));
}

static void testInc(void)
{
	Counter_Inc(counterRef);	
	ACT_TEST_ASSERT_EQUAL_INT(1, Counter_GetValue(counterRef));

	Counter_Inc(counterRef);	
	ACT_TEST_ASSERT_EQUAL_INT(2, Counter_GetValue(counterRef));
}

static void testDec(void)
{
	Counter_Dec(counterRef);
	ACT_TEST_ASSERT_EQUAL_INT(-1, Counter_GetValue(counterRef));

	Counter_Dec(counterRef);
	ACT_TEST_ASSERT_EQUAL_INT(-2, Counter_GetValue(counterRef));
}

static void testClr(void)
{
	Counter_Inc(counterRef);
	ACT_TEST_ASSERT_EQUAL_INT(1, Counter_GetValue(counterRef));

	Counter_Clr(counterRef);
	ACT_TEST_ASSERT_EQUAL_INT(0, Counter_GetValue(counterRef));
}

ITest* CounterTest_tests(void)
{
	/*
	static ITestCaller CounterTest;
	static ITestFixture fixture1;
	static ITestFixture fixture2;
	static ITestFixture fixture3;
	static ITestFixture fixture4;
	static ITestFixture fixture5;
    
	ITestCaller_Ctor(&CounterTest,"CounterTest",setUp,tearDown);
		ITestFixture_Ctor(&fixture1, "testInit",testInit);
		ITestFixture_Ctor(&fixture2, "testSetValue", testSetValue);
		ITestFixture_Ctor(&fixture3, "testInc", testInc);
		ITestFixture_Ctor(&fixture4, "testDec", testDec);
		ITestFixture_Ctor(&fixture5, "testClr", testClr);

	ITestCaller_AddTestFixture(&CounterTest,&fixture1);
	ITestCaller_AddTestFixture(&CounterTest,&fixture2);
	ITestCaller_AddTestFixture(&CounterTest,&fixture3);
	ITestCaller_AddTestFixture(&CounterTest,&fixture4);
	ITestCaller_AddTestFixture(&CounterTest,&fixture5);
	*/
	ACT_TESTCALLER_NEW(pCounterTest, "CounterTest",setUp,tearDown);
		ACT_ADD_FIXTURE(pCounterTest, "testInit",testInit);
		ACT_ADD_FIXTURE(pCounterTest, "testSetValue", testSetValue);
		ACT_ADD_FIXTURE(pCounterTest, "testInc", testInc);
		ACT_ADD_FIXTURE(pCounterTest, "testDec", testDec);
		ACT_ADD_FIXTURE(pCounterTest, "testClr", testClr);

	return (ITest*)pCounterTest;
}

