/**
* @file  exConSample.c
* @brief Console Sample
*/
#include <stdio.h>

#include "person.h"
#include "counter.h"

int Counter_Sample(void);
int Person_Sample(void);

int main (int argc, const char* argv[])
{
    int ret;
    ret = Counter_Sample();
    ret += Person_Sample();
    return ret;
}

int Counter_Sample()
{
    Counter * pCounter;
    
    pCounter = Counter_New();
    
    printf("intial value = %d\n",Counter_GetValue(pCounter));
    printf("inc value = %d\n", Counter_Inc(pCounter));    
    Counter_SetValue(pCounter, 5);
    printf("set value = %d\n", Counter_GetValue(pCounter));
    printf("dec value = %d\n", Counter_Dec(pCounter));    
    Counter_Clr(pCounter);
    printf("clear value = %d\n",Counter_GetValue(pCounter)); 
    Counter_Delete(pCounter);

    return 0;
}

int Person_Sample(void)
{
    return 0;
}
