#ifndef __ACTTEST_H__
#define __ACTTEST_H__


typedef struct __ITestResult ITestResult; 

typedef struct __ITest	ITest;

typedef struct __ITestVtbl	ITestVtbl;

typedef uint32  (*PFNTestAddRef)    (void*);
typedef void    (*PFNTestDelete)    (void*);
typedef char*   (*PFNTestName)      (void*);
typedef void    (*PFNTestRun)       (void*,ITestResult*);
typedef int     (*PFNCountTestCases)(void*);

struct __ITestVtbl 
{
    PFNTestAddRef AddRef;
    PFNTestDelete Delete;
    PFNTestName name;
    PFNTestRun run;
    PFNCountTestCases countTestCases;
};


struct __ITest {
    ITestVtbl* pvt;
};

#define ITest_AddRef(s)         (*(ITestVtbl**)s)->AddRef(s)
#define ITest_Delete(s)         (*(ITestVtbl**)s)->Delete(s)
#define ITest_name(s)           (*(ITestVtbl**)s)->name(s)
#define ITest_run(s,r)          (*(ITestVtbl**)s)->run(s,r)
#define ITest_countTestCases(s) (*(ITestVtbl**)s)->countTestCases(s)


#endif /* __ACTTEST_H__ */
