#ifndef __ACTTESTVECTOR_PRIVEATE_H__
#define __ACTTESTVECTOR_PRIVEATE_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "acttest.h"
    
struct __ITestVec {
    ITest** body;
    int size;
    int capa;
};


typedef struct __ITestVec ITestVec;

ITestVec*   ITestVec_New(int initial_capacity);
void        ITestVec_Delete(ITestVec* pMe);

void        ITestVec_push_back(ITestVec* pMe, /* const */ITest* pTest);
void        ITestVec_insert_before(ITestVec* pMe, int n, /*const*/ ITest* pTest);
void        ITestVec_erase(ITestVec* pMe, int n);
int         ITestVec_size(const ITestVec* pMe);
int         ITestVec_capacity(const ITestVec* pMe);
const ITest*ITestVec_get(const ITestVec* pMe, int n);
void        ITestVec_clear(ITestVec* pMe);
int         ITestVec_find(const ITestVec* pMe,/* const */ITest* pTest);

#ifdef __cplusplus
}
#endif

#endif /* __ACTTESTVECTOR_PRIVEATE_H__ */