#include "stdafx.h"
#include "resource.h"
#include "actMfcTestRunnerDlg.h"

//#include "	\ add additional includes here"

#include "act.h"
#include "actTestList.h"
#include "actTestRunnerMfc.h"
#include "actTestRunnerMfc_private.h"
#include "TestRunnerModel.h"

static const ITestListenerVtbl g_ITestListenerVtbl = {
    (TestListnerStartTestCallBack)	__ITestRunnerMfc_startTest,
    (TestListnerEndTestCallBack)	__ITestRunnerMfc_endTest,
    (TestListnerAddFailureCallBack)	__ITestRunnerMfc_addFailure,
};

#if 1

static void __ITestRunnerMfc_start(ITestRunnerMfc* pme);

static ITestRunnerMfcVtbl g_ITestRunnerMfcVtbl = {
    __ITestRunnerMfc_start,
    __ITestRunnerMfc_addTest,
    __ITestRunnerMfc_runTest,
    __ITestRunnerMfc_end,
};
#endif

static const ITestListener testrunner_ = {
    (ITestListenerVtbl*)&g_ITestListenerVtbl,
};

static ITestResult result_;
static ITest* root_;

/////////////////////////////////////////////////////////////////////////////
//
// ITestListener Implementation
//

static void __ITestRunnerMfc_startTest(ITestListener* self,ITest* test)
{
    act_print(".");
}

static void __ITestRunnerMfc_endTest(ITestListener* self,ITest* test)
{
    
}

static void __ITestRunnerMfc_addFailure(ITestListener* self,ITest* test,char* msg,int line,char* file)
{
    act_print("\n");
    act_print(ITest_name(root_));
    act_print(".");
    act_print(ITest_name(test));
    {
        char buf[16];
        act_print(" (");
        act_print(file);
        act_print(" ");
        act_itoa(line, buf, 10);
        act_print(buf);
        act_print(") ");
    }
    act_print(msg);
    act_print("\n");
}

/////////////////////////////////////////////////////////////////////////////
//
// ITestRunnerMfc Implementation
//

ITestRunnerMfc* ITestRunnerMfc_New()
{
    ITestRunnerMfc * pMe;
    
    pMe = ITestRunnerMfc_Alloc();
    pMe = ITestRunnerMfc_Ctor(pMe);
    return pMe;
}


void ITestRunnerMfc_Delete(ITestRunnerMfc* pMe)
{
    ITestRunnerMfc_Xtor(pMe);
    ITestRunnerMfc_Free(pMe);
}


ITestRunnerMfc* ITestRunnerMfc_Alloc()
{
    ITestRunnerMfc* pMe;
    
    pMe = (ITestRunnerMfc*) act_malloc(sizeof(ITestRunnerMfc));
    return pMe;
}

void ITestRunnerMfc_Free(ITestRunnerMfc* pMe)
{
    if(pMe)
    {
        act_free(pMe);
    }
}


ITestRunnerMfc* ITestRunnerMfc_Ctor(ITestRunnerMfc* pme)
{
    pme->pvt = &g_ITestRunnerMfcVtbl;
    pme->m_lstTest__ = ITestList_New();
    return pme;
}


void ITestRunnerMfc_Xtor(ITestRunnerMfc* pMe)
{
    if(pMe)
    {
        ITestList_Delete(pMe->m_lstTest__, TRUE);
    }
}

static void __ITestRunnerMfc_start(ITestRunnerMfc* pme)
{
    ITestResult_Ctor(&result_,NULL);
    ITestResult_init(&result_, (ITestListener*) &testrunner_);
}

static void __ITestRunnerMfc_addTest(ITestRunnerMfc* pme, ITest* test)
{
    ITestList_AddTail(pme->m_lstTest__, test);
}

static void __ITestRunnerMfc_runTest(ITestRunnerMfc* pMe)
{
    ITestNode* pNode;
    ITest* test;
    int nCount;
    int index;

    pNode = (ITestNode*) ITestList_GetHeadPosition(pMe->m_lstTest__);
    nCount = ITestList_GetCount(pMe->m_lstTest__);
    for(index = 0; index < nCount; index++)
    {
        test = (ITest*) ITestList_GetNext(pMe->m_lstTest__, &pNode);
        root_ = test;
        ITest_run(test, &result_);
    }
#if 1
     bool comInit = SUCCEEDED( CoInitialize( NULL) );

     TestRunnerModel(  m_lstTest__);
//	actMfcTestRunnerDlg dlg;

//    dlg.SetTestList(pMe->m_lstTest__);

//	dlg.DoModal();
#endif 
}


static void __ITestRunnerMfc_end(ITestRunnerMfc* pme)
{
    char buf[16];
    if (result_.failureCount) {
        act_print("\nrun ");
        act_itoa(result_.runCount, buf, 10);
        act_print(buf);
        act_print(" failures ");
        act_itoa(result_.failureCount, buf, 10);
        act_print(buf);
        act_print("\n");
    } else {
        act_print("\nOK (");
        act_itoa(result_.runCount, buf, 10);
        act_print(buf);
        act_print(" tests)\n");
    }
}
