#include "act.h"
#include "person.h"

Person* personRef;

static void setUp(void)
{
	personRef = Person_NewWithName("test tarou");
}

static void tearDown(void)
{
	Person_Delete(personRef);
}

static void testfullname(void)
{
	ACT_TEST_ASSERT_EQUAL_STRING("test tarou", (const char*) Person_fullName(personRef));
}

static void testfirstname(void)
{
	ACT_TEST_ASSERT_EQUAL_STRING("test", (const char*)Person_firstName(personRef));
}

static void testlastname(void)
{
	ACT_TEST_ASSERT_EQUAL_STRING("tarou", (const char*)Person_lastName(personRef));
}

static void testsetfullname(void)
{
	Person_SetFullName(personRef, "sample hanako");

	ACT_TEST_ASSERT_EQUAL_STRING("sample hanako", (const char*)Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("sample", (const char*)Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("hanako", (const char*)Person_lastName(personRef));
}

static void testsetfirstname(void)
{
	Person_setFirstName(personRef, "sample");

	ACT_TEST_ASSERT_EQUAL_STRING("sample tarou", (const char*)Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("sample", (const char*)Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("tarou", (const char*)Person_lastName(personRef));
}

static void testsetlastname(void)
{
	Person_setLastName(personRef, "hanako");

	ACT_TEST_ASSERT_EQUAL_STRING("test hanako", (const char*) Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("test", (const char*) Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("hanako", (const char*)Person_lastName(personRef));
}

static void testnullcharfullname(void)
{
	Person_SetFullName(personRef, "");

	ACT_TEST_ASSERT_EQUAL_STRING("", (const char*)Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("", (const char*)Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("", (const char*)Person_lastName(personRef));
}

static void testnullpointerfullname(void)
{
	Person_SetFullName(personRef, NULL);

	ACT_TEST_ASSERT_NULL(Person_fullName(personRef));
	ACT_TEST_ASSERT_NULL(Person_firstName(personRef));
	ACT_TEST_ASSERT_NULL(Person_lastName(personRef));
}

static void testnosepfullname(void)
{
	Person_SetFullName(personRef, "sample");

	ACT_TEST_ASSERT_EQUAL_STRING("sample", (const char*)Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("sample", (const char*)Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("", (const char*)Person_lastName(personRef));

	Person_setLastName(personRef, "tarou");
	ACT_TEST_ASSERT_EQUAL_STRING("sample tarou", (const char*)Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("sample", (const char*)Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("tarou", (const char*)Person_lastName(personRef));

	Person_setFirstName(personRef, "test");
	ACT_TEST_ASSERT_EQUAL_STRING("test tarou", (const char*)Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("test", (const char*)Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("tarou", (const char*)Person_lastName(personRef));
}

ITest* PersonTest_tests(void)
{
/*
	static ITestCaller PersonTest;
	static ITestFixture fixture1;
	static ITestFixture fixture2;
	static ITestFixture fixture3;
	static ITestFixture fixture4;
	static ITestFixture fixture5;
	static ITestFixture fixture6;
	static ITestFixture fixture7;
	//static ITestFixture fixture8;
	//static ITestFixture fixture9;

	ITestCaller_Ctor(&PersonTest,"PersonTest",setUp,tearDown);

		ITestFixture_Ctor(&fixture1,"testfullname",testfullname);
		ITestFixture_Ctor(&fixture2,"testfirstname",testfirstname);
		ITestFixture_Ctor(&fixture3,"testlastname",testlastname);
		ITestFixture_Ctor(&fixture4,"testsetfullname",testsetfullname);
		ITestFixture_Ctor(&fixture5,"testsetfirstname",testsetfirstname);
		ITestFixture_Ctor(&fixture6,"testsetlastname",testsetlastname);
		ITestFixture_Ctor(&fixture7,"testnullcharfullname",testnullcharfullname);
		//ITestFixture_Ctor(&fixture8,"testnullpointerfullname",testnullpointerfullname);
		//ITestFixture_Ctor(&fixture9,"testnosepfullname",testnosepfullname);

	ITestCaller_AddTestFixture(&PersonTest,&fixture1);
	ITestCaller_AddTestFixture(&PersonTest,&fixture2);
	ITestCaller_AddTestFixture(&PersonTest,&fixture3);
	ITestCaller_AddTestFixture(&PersonTest,&fixture4);
	ITestCaller_AddTestFixture(&PersonTest,&fixture5);
	ITestCaller_AddTestFixture(&PersonTest,&fixture6);
	ITestCaller_AddTestFixture(&PersonTest,&fixture7);
	//ITestCaller_AddTestFixture(&PersonTest,&fixture8);
	//ITestCaller_AddTestFixture(&PersonTest,&fixture9);
	{
		static ITestFixture fixture8;
		ITestFixture_Ctor(&fixture8,"testnullpointerfullname",testnullpointerfullname);
		ITestCaller_AddTestFixture(&PersonTest,&fixture8);
	}
	{
		static ITestFixture fixture8;
		ITestFixture_Ctor(&fixture8,"testnosepfullname",testnosepfullname);
		ITestCaller_AddTestFixture(&PersonTest,&fixture8);
	}

*/
    ACT_TESTCALLER_NEW(pPersonTest,"PersonTest",setUp,tearDown);
               ACT_ADD_FIXTURE(pPersonTest,"testfullname",testfullname);
		ACT_ADD_FIXTURE(pPersonTest,"testfirstname",testfirstname);
		ACT_ADD_FIXTURE(pPersonTest,"testlastname",testlastname);
		ACT_ADD_FIXTURE(pPersonTest,"testsetfullname",testsetfullname);
		ACT_ADD_FIXTURE(pPersonTest,"testsetfirstname",testsetfirstname);
		ACT_ADD_FIXTURE(pPersonTest,"testsetlastname",testsetlastname);
		ACT_ADD_FIXTURE(pPersonTest,"testnullcharfullname",testnullcharfullname);
		ACT_ADD_FIXTURE(pPersonTest,"testnullpointerfullname",testnullpointerfullname);
		ACT_ADD_FIXTURE(pPersonTest,"testnosepfullname",testnosepfullname);


	return (ITest*)pPersonTest;
}

