#ifndef __ACTTESTFIXTURELIST_PRIVATE_H__
#define __ACTTESTFIXTURELIST_PRIVATE_H__

#include "acttestfixturelist.h"


struct __ITestFixtureNode {

	struct __ITestFixtureNode* pPrev;
	struct __ITestFixtureNode* pNext;
	ITestFixture*               pData;
};


struct __ITestFixtureList
{
    ITestFixtureListVtbl         * pvt;
	int		nNodeCount; ///< number (default : 0)
	struct __ITestFixtureNode* 	lpNodeHead; ///< pointer to the node of head (default : null)
	struct __ITestFixtureNode*	lpNodeTail; ///< pointer to the node of tail(default: null)
};


static const ITestFixture* List_GetHead(ITestFixtureList *pMe);
static const ITestFixture* List_GetTail(ITestFixtureList *pMe);
static ITestFixture* List_RemoveHead(ITestFixtureList *pMe, boolean bDataDelete) ;
static ITestFixture* List_RemoveTail(ITestFixtureList *pMe, boolean bDataDelete);
static ITestFixtureNode* List_AddHead(ITestFixtureList *pMe, ITestFixture* pData);
static ITestFixtureNode* List_AddTail(ITestFixtureList *pMe, ITestFixture* pData);
static void List_RemoveAll(ITestFixtureList *pMe, boolean bDataDelete);
static const ITestFixtureNode* List_GetHeadPosition(ITestFixtureList *pMe);
static const ITestFixtureNode* List_GetTailPosition(ITestFixtureList *pMe);
static const ITestFixture* List_GetNext(ITestFixtureList *pMe, ITestFixtureNode** ppPosition);
static const ITestFixture* List_GetPrev(ITestFixtureList *pMe, ITestFixtureNode** ppPosition);
static const ITestFixture* List_GetAt(ITestFixtureList *pMe, ITestFixtureNode* position);
static void List_SetAt(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture* newElement, boolean bDeleteData);
static void List_RemoveAt(ITestFixtureList *pMe, ITestFixtureNode* position, boolean bDeleteData);
static ITestFixtureNode* List_InsertBefore(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture* newElement);
static ITestFixtureNode* List_InsertAfter(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture*newElement);
static const ITestFixtureNode* List_Find(ITestFixtureList *pMe, ITestFixture* searchValue, ITestFixtureNode* startAfter);
static const ITestFixtureNode* List_FindIndex(ITestFixtureList *pMe, int nIndex);
static const int List_GetNo(ITestFixtureList *pMe, ITestFixture* searchValue, ITestFixtureNode* startAfter);
static int List_GetCount(ITestFixtureList *pMe);
static boolean List_IsEmpty(ITestFixtureList *pMe);

#endif // __ACTTESTFIXTURELIST_PRIVATE_H__

