#ifndef __ACTTESTVECTOR_PRIVEATE_H__
#define __ACTTESTVECTOR_PRIVEATE_H__

#ifdef __cplusplus
extern "C" {
#endif

       
struct __ITestVec {
    ITestVecVtbl *pvt;
    uint32 m_cRef;
    ITest** body;
    int size;
    int capa;
};


static uint32      __ITestVec_AddRef(ITestVec* pMe);
static void        __ITestVec_Delete(ITestVec* pMe);

static void        __ITestVec_push_back(ITestVec* pMe, ITest* pTest);
static void        __ITestVec_insert_before(ITestVec* pMe, int n, ITest* pTest);
static void        __ITestVec_erase(ITestVec* pMe, int n);
static int         __ITestVec_size(ITestVec* pMe);
static int         __ITestVec_capacity(ITestVec* pMe);
static ITest*      __ITestVec_get(ITestVec* pMe, int n);
static void        __ITestVec_clear(ITestVec* pMe);
static int         __ITestVec_find(ITestVec* pMe,ITest* pTest);

//
// Test Vector Iterator
//

struct __ITestVecIterator {
    ITestVecIteratorVtbl *pvt;
    uint32  m_cRef;
    ITestVec* m_pTestVec_;
    int32 m_nCurrent_;
};

static uint32  __ITestVecIterator_AddRef(ITestVecIterator* pme);
static void    __ITestVecIterator_Delete(ITestVecIterator* pme);
static void    __ITestVecIterator_First(ITestVecIterator* pme);
static void    __ITestVecIterator_Next(ITestVecIterator* pme);
static boolean __ITestVecIterator_IsDone(ITestVecIterator* pme);
static ITest* __ITestVecIterator_CurrentItem(ITestVecIterator* pme);

#ifdef __cplusplus
}
#endif

#endif /* __ACTTESTVECTOR_PRIVEATE_H__ */