// TestRunnerModel.h: interface for the TestRunnerModel class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TESTRUNNERMODEL_H__C2E3A6F9_1087_41F7_AF11_606147B1F071__INCLUDED_)
#define AFX_TESTRUNNERMODEL_H__C2E3A6F9_1087_41F7_AF11_606147B1F071__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <deque>
#include "act.h"
#include "actTest.h"


/*! \class TestRunnerModel
 * \brief This class represents a model for the test runner.
 */
class TestRunnerModel  
{
public:
  static const CString settingKey;
  static const CString settingMainDialogKey;
  static const CString settingBrowseDialogKey;

  struct Settings
  {
    bool autorunOnLaunch;
    int  col_1; // 1st column width in list view
    int  col_2; // 2nd column width in list view
    int  col_3; // 3rd column width in list view
    int  col_4; // 4th column width in list view  
  };

  typedef std::deque<ITest *> History;

  /*! Constructs a TestRunnerModel object.
   */
  TestRunnerModel(ITest *rootTest);

  /*! Destructor.
   */
	virtual ~TestRunnerModel();

  virtual void setRootTest( ITest *rootTest );

  void loadSettings(Settings & s);
  void saveSettings(const Settings & s);

  const History &history() const;
  void selectHistoryTest( ITest *test );
  ITest *selectedTest() const;

  ITest *rootTest();

protected:
  void loadHistory();
  CString loadHistoryEntry( int idx );
  ITest *findTestByName( CString name ) const;
  ITest *findTestByNameFor( const CString &name, 
                                    ITest *test ) const;

  void saveHistoryEntry( int idx, 
                         CString testName );

  CString getHistoryEntryName( int idx ) const;

  static std::string toAnsiString( const CString &text );

private:
  /// Prevents the use of the copy constructor.
  TestRunnerModel( const TestRunnerModel &copy );

  /// Prevents the use of the copy operator.
  TestRunnerModel &operator =( const TestRunnerModel &copy );

protected:
  History m_history;

  ITest *m_rootTest;
};

// Inlines methods for TestRunnerModel:
// ------------------------------------


#endif // !defined(AFX_TESTRUNNERMODEL_H__C2E3A6F9_1087_41F7_AF11_606147B1F071__INCLUDED_)
