#include "stdafx.h"
#include "resource.h"
#include "TestRunnerDlg.h"

//#include "	\ add additional includes here"

#include "act.h"
#include "actTestList.h"
#include "acttestvector.h"
#include "actTestRunnerMfc.h"
#include "actTestRunnerMfc_private.h"
#include "TestRunnerModel.h"


#ifdef TEST_RUNNER_MFC_V1
static const ITestListenerVtbl g_ITestListenerVtbl = {
    (TestListnerStartTestCallBack)	__ITestRunnerMfc_startTest,
    (TestListnerEndTestCallBack)	__ITestRunnerMfc_endTest,
    (TestListnerAddFailureCallBack)	__ITestRunnerMfc_addFailure,
};
#endif 

static ITestRunnerMfcVtbl g_ITestRunnerMfcVtbl = {
    __ITestRunnerMfc_start
    ,__ITestRunnerMfc_addTest
    ,__ITestRunnerMfc_runTest
    ,__ITestRunnerMfc_end
    ,__ITestRunnerMfc_getRootTest
};

#ifdef TEST_RUNNER_MFC_V1
static const ITestListener testrunner_ = {
    (ITestListenerVtbl*)&g_ITestListenerVtbl,
};


static ITestResult result_;
static ITest* root_;

#endif

#ifdef TEST_LISTENER_MFC_V1

/////////////////////////////////////////////////////////////////////////////
//
// ITestListener Implementation
//

static void __ITestRunnerMfc_startTest(ITestListener* self,ITest* test)
{
    act_print(".");
}

static void __ITestRunnerMfc_endTest(ITestListener* self,ITest* test)
{
    
}

static void __ITestRunnerMfc_addFailure(ITestListener* self,ITest* test,char* msg,int line,char* file)
{
    act_print("\n");
    act_print(ITest_name(root_));
    act_print(".");
    act_print(ITest_name(test));
    {
        char buf[16];
        act_print(" (");
        act_print(file);
        act_print(" ");
        act_itoa(line, buf, 10);
        act_print(buf);
        act_print(") ");
    }
    act_print(msg);
    act_print("\n");
}
#endif

/////////////////////////////////////////////////////////////////////////////
//
// ITestRunnerMfc Implementation
//

ITestRunnerMfc* ITestRunnerMfc_New()
{
    ITestRunnerMfc * pMe;
    
    pMe = ITestRunnerMfc_Alloc();
    pMe = ITestRunnerMfc_Ctor(pMe);
    return pMe;
}


void ITestRunnerMfc_Delete(ITestRunnerMfc* pMe)
{
    ITestRunnerMfc_Xtor(pMe);
    ITestRunnerMfc_Free(pMe);
}


ITestRunnerMfc* ITestRunnerMfc_Alloc()
{
    ITestRunnerMfc* pMe;
    
    pMe = (ITestRunnerMfc*) act_malloc(sizeof(ITestRunnerMfc));
    return pMe;
}

void ITestRunnerMfc_Free(ITestRunnerMfc* pMe)
{
    if(pMe)
    {
        act_free(pMe);
    }
}



ITestRunnerMfc* ITestRunnerMfc_Ctor(ITestRunnerMfc* pme)
{
    pme->pvt = &g_ITestRunnerMfcVtbl;
    pme->m_suite_ = ITestSuite_New( "All Tests" );
#ifdef TEST_RUNNER_MFC_V1
    pme->m_lstTest__ = ITestList_New();
#endif
    pme->m_tests = ITestVec_New(8);
    return pme;
}


void ITestRunnerMfc_Xtor(ITestRunnerMfc* pMe)
{
    ITest* pTest;
    ITestVecIterator* pIterator;
    if(pMe)
    {
        ITest_Delete(pMe->m_suite_);
#ifdef TEST_RUNNER_MFC_V1
        ITestList_Delete(pMe->m_lstTest__, TRUE);
#endif
        //
        pIterator = ITestVecIterator_New(pMe->m_tests);
        for(ITestVecIterator_First(pIterator);!ITestVecIterator_IsDone(pIterator);ITestVecIterator_Next(pIterator))
        {
            pTest = ITestVecIterator_CurrentItem(pIterator);
            ITest_Delete(pTest);
        }
        ITestVecIterator_Delete(pIterator);
    }
}

static void __ITestRunnerMfc_start(ITestRunnerMfc* pme)
{
#ifdef TEST_RUNNER_MFC_V1
    ITestResult_Ctor(&result_,NULL);
    ITestResult_init(&result_, (ITestListener*) &testrunner_);
#endif	
}

static void __ITestRunnerMfc_addTest(ITestRunnerMfc* pme, ITest* test)
{
#ifdef TEST_RUNNER_MFC_V1
    ITestList_AddTail(pme->m_lstTest__, test);
#endif

    ITestVec_push_back(pme->m_tests, test);
}

static void __ITestRunnerMfc_runTest(ITestRunnerMfc* pMe)
{
#ifdef TEST_RUNNER_MFC_V1
    ITestNode* pNode;
    ITest* test;
    int nCount;
    int index;

    pNode = (ITestNode*) ITestList_GetHeadPosition(pMe->m_lstTest__);
    nCount = ITestList_GetCount(pMe->m_lstTest__);
    for(index = 0; index < nCount; index++)
    {
        test = (ITest*) ITestList_GetNext(pMe->m_lstTest__, &pNode);
        root_ = test;
        ITest_run(test, &result_);
    }
#endif
#if 1
     bool comInit = SUCCEEDED( CoInitialize( NULL) );

     TestRunnerModel model( ITestRunnerMfc_getRootTest(pMe));

     TestRunnerDlg dlg(&model);

     dlg.DoModal();

     if(comInit)
         CoUninitialize();
#endif 
}


static void __ITestRunnerMfc_end(ITestRunnerMfc* pme)
{
#ifdef TEST_RUNNER_MFC_V1
    char buf[16];
    if (result_.failureCount) {
        act_print("\nrun ");
        act_itoa(result_.runCount, buf, 10);
        act_print(buf);
        act_print(" failures ");
        act_itoa(result_.failureCount, buf, 10);
        act_print(buf);
        act_print("\n");
    } else {
        act_print("\nOK (");
        act_itoa(result_.runCount, buf, 10);
        act_print(buf);
        act_print(" tests)\n");
    }
#endif
}


static ITest*   __ITestRunnerMfc_getRootTest(ITestRunnerMfc* pme)
{
    if(ITestVec_size(pme->m_tests) != 1)
    {        
        ITestVecIterator* pIt;
        ITest* pTest;

        pIt = ITestVecIterator_New(pme->m_tests);
        for(ITestVecIterator_First(pIt); !ITestVecIterator_IsDone(pIt); ITestVecIterator_Next(pIt))
        {
            pTest = ITestVecIterator_CurrentItem(pIt);
            ITestSuite_AddTest(pme->m_suite_, pTest);
        }
        ITestVecIterator_Delete(pIt);

        ITestVec_clear(pme->m_tests);

        return (ITest*)pme->m_suite_;
    }
    return ITestVec_get(pme->m_tests, 0);
}
