#include "act.h"
#include "actTests.h"

#ifdef ACT_TESTCALLER_TESTS

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testOneFixture(void)
{
    /*
    TestFixture	fixtures[] = {
    new_TestFixture(NULL,NULL),
    };
    TestCaller caller = new_TestCaller(NULL,NULL,NULL,1,fixtures);
    TestResult result = new_TestResult(NULL);

    caller.isa->run(&caller,&result);
    */
    
    
//    static ITestCaller caller;
    ITestCaller* pCaller;
    static ITestResult result;

    pCaller = ITestCaller_New("", NULL, NULL);
    ITestResult_Ctor(&result, NULL);
    {
        ITestFixture* pFixture;
        pFixture = ITestFixture_New("",NULL);
        ITestCaller_AddTestFixture(pCaller, pFixture);
    }
    
    ITest_run (pCaller,&result);
    
    ACT_TEST_ASSERT_EQUAL_INT(1, result.runCount);
    ACT_TEST_ASSERT_EQUAL_INT(1, ITest_countTestCases(pCaller));

    ITest_Delete(pCaller);
}

static void testMoreThanOne(void)
{
    //static ITestCaller caller;
    ITestCaller* caller;
    static ITestResult result;
    
    caller = ITestCaller_New( "", NULL, NULL);
    ITestResult_Ctor(&result, NULL);
    
    ACT_ADD_FIXTURE(caller, "", NULL);
    ACT_ADD_FIXTURE(caller, "", NULL);
    ACT_ADD_FIXTURE(caller, "", NULL);
    ACT_ADD_FIXTURE(caller, "", NULL);
    ACT_ADD_FIXTURE(caller, "", NULL);

    ITest_run(caller, &result);
    
    ACT_TEST_ASSERT_EQUAL_INT(5, result.runCount);
    ACT_TEST_ASSERT_EQUAL_INT(5, ITest_countTestCases(caller));
    
    ITest_Delete(caller);
}

static void testZeroFixture(void)
{
    //static ITestCaller caller;
    ITestCaller* caller;
    static ITestResult result;
    
    caller = ITestCaller_New("", NULL, NULL);
    ITestResult_Ctor(&result, NULL);
    
    ITest_run(caller, &result);
    
    
    ACT_TEST_ASSERT_EQUAL_INT(0, result.runCount);
    ACT_TEST_ASSERT_EQUAL_INT(0, ITest_countTestCases(caller));

    ITest_Delete(caller);
}

ITest* TestCallerTest_tests(void)
{
    ACT_TESTCALLER_NEW( pTestCallerTest, "TestCallerTest", setUp, tearDown);
        ACT_ADD_FIXTURE(pTestCallerTest, "testOneFixture", testOneFixture);
        ACT_ADD_FIXTURE(pTestCallerTest, "testMoreThanOne", testMoreThanOne);
        ACT_ADD_FIXTURE(pTestCallerTest, "testZeroFixture", testZeroFixture);
    
    return (ITest*)pTestCallerTest;
}

#endif // def ACT_TESTCALLER_TESTS
