/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "person.h"

Person* Person_Alloc(void)
{
	return (Person*)malloc(sizeof(Person));
}

void Person_Free(Person* pMe)
{
	if (pMe) {
		free(pMe->fullname);
		free(pMe->firstname);
		free(pMe->lastname);
		free(pMe);
	}
}

Person* Person_Ctor(Person* pMe)
{
	return Person_CtorWithName(pMe, NULL);
}

Person* Person_CtorWithName(Person* pMe,char *fullname)
{
	pMe->fullname = NULL;
	pMe->firstname = NULL;
	pMe->lastname = NULL;
	Person_SetFullName(pMe,fullname);
	return pMe;
}

Person* Person_NewWithName(char *fullname)
{
	return Person_CtorWithName(Person_Alloc(),fullname);
}

void      Person_Delete(Person* pMe)
{
    Person_Free(pMe);
}

static void setfullname(Person* pMe,char *fullname)
{
	free(pMe->fullname);
	pMe->fullname = NULL;
	if (fullname) {
		pMe->fullname = (char*)malloc(strlen(fullname)+1);
		strcpy(pMe->fullname,fullname);
	}
}

static void setfirstname(Person* pMe,char *firstname)
{
	free(pMe->firstname);
	pMe->firstname = NULL;
	if (firstname) {
		pMe->firstname = (char*)malloc(strlen(firstname)+1);
		strcpy(pMe->firstname,firstname);
	}
}

static void setlastname(Person* pMe,char *lastname)
{
	free(pMe->lastname);
	pMe->lastname = NULL;
	if (lastname) {
		pMe->lastname = (char*)malloc(strlen(lastname)+1);
		strcpy(pMe->lastname,lastname);
	}
}

static void makefullname(Person* pMe)
{
	size_t fl,ll,fulllen,pos;
	fl = ll = fulllen = pos = 0;
	if (pMe->firstname) {
		fl = strlen(pMe->firstname);
	}
	if (pMe->lastname) {
		ll = strlen(pMe->lastname);
	}
	if (fl) {
		fulllen = fl + 1;	/* + space */
	}
	if (ll) {
		fulllen = fulllen + ll + 1;	/* + null */
	}
	if (fulllen) {
		pMe->fullname = (char*)malloc(fulllen);
		if (fl && ll) {
			sprintf(pMe->fullname,"%s %s",pMe->firstname,pMe->lastname);
		} else {
			if (fl) {
				strcpy(pMe->fullname,pMe->firstname);
			}
			if (ll) {
				strcpy(pMe->fullname,pMe->lastname);
			}
		}
	}
}

static void makefirstname(Person* pMe)
{
	if (pMe->fullname) {
		char *p;
		int len;
		p = strchr(pMe->fullname, ' ');
		if (p) {
			len = (int)(p - pMe->fullname);
			p = (char*)malloc(len + 1);
			strncpy(p,pMe->fullname,len);
			p[len] = '\0';
			setfirstname(pMe,p);
			free(p);
		} else {
			setfirstname(pMe,pMe->fullname);
		}
	}
}

static void makelastname(Person* pMe)
{
	if (pMe->fullname) {
		char *p = strchr(pMe->fullname, ' ');
		if (p) {
			setlastname(pMe,p+1);
		} else {
			setlastname(pMe,"");
		}
	}
}

char* Person_fullName(Person* pMe)
{
	if (pMe->fullname == NULL) {
		makefullname(pMe);
	}
	return pMe->fullname;
}

char* Person_firstName(Person* pMe)
{
	if (pMe->firstname == NULL) {
		makefirstname(pMe);
	}
	return pMe->firstname;
}

char* Person_lastName(Person* pMe)
{
	if (pMe->lastname == NULL) {
		makelastname(pMe);
	}
	return pMe->lastname;
}

void Person_SetFullName(Person* pMe,char *fullname)
{
	setfullname(pMe,fullname);
	setfirstname(pMe,NULL);
	setlastname(pMe,NULL);
}

void Person_setFirstName(Person* pMe,char *firstname)
{
	if (pMe->lastname == NULL) {
		makelastname(pMe);
	}
	setfirstname(pMe,firstname);
	setfullname(pMe,NULL);
}

void Person_setLastName(Person* pMe,char *lastname)
{
	if (pMe->firstname == NULL) {
		makefirstname(pMe);
	}
	setlastname(pMe,lastname);
	setfullname(pMe,NULL);
}
