/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTFIXTURE_H__
#define __ACTTESTFIXTURE_H__

typedef void(*PFNTEST)(void);

typedef struct __ITestFixture	ITestFixture;

typedef struct __ITestFixtureVtbl ITestFixtureVtbl;

struct __ITestFixtureVtbl {
    uint32 (* addRef) (ITestFixture* pobj);
    uint32 (* release) (ITestFixture* pobj);
    ACTRESULT (*queryInterface)(ITestFixture* pobj, ACTCLSID clsid, void ** ppNew);
    ACTRESULT (*init)(ITestFixture* pobj, char* name, PFNTEST test);
    char*	(*name)(ITestFixture* po);
    PFNTEST (*test)(ITestFixture* po);    
};

#define ITestFixture_addRef(pobj)         (*(ITestFixtureVtbl**)pobj)->addRef(pobj)
#define ITestFixture_release(pobj)         (*(ITestFixtureVtbl**)pobj)->release(pobj)
#define ITestFixture_queryInterface(po,id,ppn) (*((ITestFixtureVtbl**)po))->queryInterface(po,id,ppn)

#define ITestFixture_init(pobj, name, test) (*((ITestFixtureVtbl**)pobj))->init(pobj, name, test)
#define ITestFixture_name(p) (*(ITestFixtureVtbl**)p)->name(p)
#define ITestFixture_test(p) (*(ITestFixtureVtbl**)p)->test(p)

#endif //  __ACTTESTFIXTURE_H__

