/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef	__ACTTESTSUITE_H__
#define	__ACTTESTSUITE_H__

typedef struct __ITestSuite	ITestSuite;

typedef struct __ITestSuiteVtbl ITestSuiteVtbl;

struct __ITestSuiteVtbl
{
///    ITestVtbl super_;
    uint32 (* addRef) (ITestSuite* pobj);
    uint32 (* release) (ITestSuite* pobj);
    ACTRESULT (*queryInterface)(ITestSuite* pobj, ACTCLSID clsid, void ** ppNew);
    char* (*name)(ITestSuite* pobj);
    void (*run)(ITestSuite* pobj, ITestResult* pResult);
    int  (*countTestCases)(ITestSuite* pobj);
    int  (*getChildTestCount)(ITestSuite* pobj);
    ITest* (*getChildTestAt)(ITestSuite* pobj, int index);
    ITest* (*findTest)(ITestSuite* pobj, char *name);

    void(*addTest)(ITestSuite* pme, ITest* pITest);
    ITest* (*findName)(ITestSuite* pme,char * pszName);
    ACTRESULT (*init)(ITestSuite* pme,char * pszName);
};


//ITestSuite* ITestSuite_New(char* name);
//ITestSuite* ITestSuite_Ctor(ITestSuite* pme, char* name, int numberOfTests, ITest** tests);
//ITestSuite* ITestSuite_Ctor(ITestSuite* pme, char* name);
#define ITestSuite_addRef(pobj)             (*(ITestSuiteVtbl**)pobj)->addRef(pobj)
#define ITestSuite_release(pobj)            (*(ITestSuiteVtbl**)pobj)->release(pobj)
#define ITestSuite_queryInterface(po,id,ppn) (*((ITestSuiteVtbl**)po))->queryInterface(po,id,ppn)
#define ITestSuite_name(pobj)               (*(ITestSuiteVtbl**)pobj)->name(pobj)
#define ITestSuite_run(pobj,r)              (*(ITestSuiteVtbl**)pobj)->run(pobj,r)
#define ITestSuite_countTestExCases(pobj)   (*(ITestSuiteVtbl**)pobj)->countTestCases(pobj)
#define ITestSuite_getChildTestCount(pobj)  (*(ITestSuiteVtbl**)pobj)->getChildTestCount(pobj)
#define ITestSuite_getChildTestAt(pobj,i)   (*(ITestSuiteVtbl**)pobj)->getChildTestAt(pobj,i)
#define ITestSuite_findTest(pobj,n)         (*(ITestSuiteVtbl**)pobj)->findTest(pobj,n)

#define ITestSuite_addTest(pobj, pITest)    (*(ITestSuiteVtbl**)pobj)->addTest(pobj, pITest)
#define ITestSuite_findName(pobj, pName)    (*(ITestSuiteVtbl**)pobj)->findName(pobj, pName)
#define ITestSuite_init(pobj, pName)        (*(ITestSuiteVtbl**)pobj)->init(pobj, pName)
#endif/*__ACTTESTSUITE_H__*/

