/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTCALLER_PROTECTED_H__
#define  __ACTTESTCALLER_PROTECTED_H__

#include "acttestcaller.h"
#include "acttestfixturelist.h"

struct __ITestCaller 
{
	ITestCallerVtbl* pvt;
    uint32 m_cRef;
	char name[ACT_TEST_NAME_LENGTH];
	void(*setUp)(void);
	void(*tearDown)(void);
    ITestFixtureList * m_lstFixture;
};

ACTRESULT 
_ITestCaller_new(ITestCaller** ppobj);

void 
_ITestCaller_ctor(ITestCaller* pme, ITestCallerVtbl* pvt);

void 
_ITestCaller_initVtbl(ITestCallerVtbl* pvt);

ACTRESULT 
_ITestCaller_init(ITestCaller* pobj, char * name, PFNSETUP setup, PFNTEARDWON tdw);

uint32 
_ITestCaller_addRef(ITestCaller* pobj);

uint32 
_ITestCaller_release(ITestCaller* pobj);

void 
_ITestCaller_xtor(ITestCaller* pme);

ACTRESULT 
_ITestCaller_queryInterface(ITestCaller* pobj, ACTCLSID clsid, void ** ppNew);

char*    
_ITestCaller_name(ITestCaller* pme);

void     
_ITestCaller_run(ITestCaller* pme,ITestResult* result);

int      
_ITestCaller_countTestCases(ITestCaller* pme);

int      
_ITestCaller_getChildTestCount(ITestCaller* pme);

ITest*      
_ITestCaller_getChildTestAt(ITestCaller* pme, int index);

void     
_ITestCaller_AddTestFixture(ITestCaller* pme, ITestFixture* pFixture);

ITest*     
_ITestCaller_findTest(ITestCaller* pme, char *pszName);

void 
_ITestCaller_addTestFixture(ITestCaller* pme, ITestFixture* pFixture);

#endif /*  __ACTTESTCALLER_PROTECTED_H__ */

