/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTCASE_PROTECTED_H__
#define __ACTTESTCASE_PROTECTED_H__
/**
@file acttestcase_protected.h

@brief TestCase Protected header file

*/

#include "acttestcase.h"

struct __ITestCase {
    ITestCaseVtbl* pvt;
    uint32 m_cRef;
	char name[ACT_TEST_NAME_LENGTH];
	void(*setUp)(void);
	void(*tearDown)(void);
	void(*runTest)(void);    
};

ACTRESULT 
_ITestCase_new(ITestCase** ppobj);

void            
_ITestCase_ctor(ITestCase* pobj, ITestCaseVtbl* pvt);

void 
_ITestCase_initVtbl(ITestCaseVtbl* pvt);

ACTRESULT 
_ITestCase_init(ITestCase* pobj, char * name, PFNSETUP setup, PFNTEARDWON teardown, PFNRUNTEST runTest);

uint32         
_ITestCase_addRef(ITestCase* pobj);

uint32          
_ITestCase_release(ITestCase* pobj);

void            
_ITestCase_xtor(ITestCase* pobj);

ACTRESULT   
_ITestCase_queryInterface(ITestCase* pobj, ACTCLSID clsid, void ** ppNew);

char* 
_ITestCase_name(ITestCase* pobj);

void 
_ITestCase_run(ITestCase* pme,ITestResult* pResult);


int 
_ITestCase_countTestCases(ITestCase* pme);


int 
_ITestCase_getChildTestCount(ITestCase* pme);


ITest* 
_ITestCase_getChildTestAt(ITestCase* pme, int index);


ITest* 
_ITestCase_findTest(ITestCase* pme,char * pszName);


void
_ITestCase_setName(ITestCase* pobj, char * name);


void
_ITestCase_setRunTest(ITestCase* pobj, PFNRUNTEST runTest);

void 
_act_addFailure(const char *msg, long line, const char *file);

#endif /* __ACTTESTCASE_PROTECTED_H__ */
