/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTFIXTURELIST_PRIVATE_H__
#define __ACTTESTFIXTURELIST_PRIVATE_H__

#include "acttestfixturelist_protected.h"

static const ITestFixture* List_getHead(ITestFixtureList *pMe);
static const ITestFixture* List_getTail(ITestFixtureList *pMe);
static ITestFixture* List_removeHead(ITestFixtureList *pMe, boolean bDataDelete) ;
static ITestFixture* List_removeTail(ITestFixtureList *pMe, boolean bDataDelete);
static ITestFixtureNode* List_addHead(ITestFixtureList *pMe, ITestFixture* pData);
static ITestFixtureNode* List_addTail(ITestFixtureList *pMe, ITestFixture* pData);
static void List_removeAll(ITestFixtureList *pMe, boolean bDataDelete);
static const ITestFixtureNode* List_getHeadPosition(ITestFixtureList *pMe);
static const ITestFixtureNode* List_getTailPosition(ITestFixtureList *pMe);
static const ITestFixture* List_getNext(ITestFixtureList *pMe, ITestFixtureNode** ppPosition);
static const ITestFixture* List_getPrev(ITestFixtureList *pMe, ITestFixtureNode** ppPosition);
static const ITestFixture* List_getAt(ITestFixtureList *pMe, ITestFixtureNode* position);
static void List_setAt(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture* newElement, boolean bDeleteData);
static void List_removeAt(ITestFixtureList *pMe, ITestFixtureNode* position, boolean bDeleteData);
static ITestFixtureNode* List_insertBefore(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture* newElement);
static ITestFixtureNode* List_insertAfter(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture*newElement);
static const ITestFixtureNode* List_find(ITestFixtureList *pMe, ITestFixture* searchValue, ITestFixtureNode* startAfter);
static const ITestFixtureNode* List_findIndex(ITestFixtureList *pMe, int nIndex);
static const int List_getNo(ITestFixtureList *pMe, ITestFixture* searchValue, ITestFixtureNode* startAfter);
static int List_getCount(ITestFixtureList *pMe);
static boolean List_isEmpty(ITestFixtureList *pMe);

#endif // __ACTTESTFIXTURELIST_PRIVATE_H__

