/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTFIXTURELIST_PROTECTED_H__
#define __ACTTESTFIXTURELIST_PROTECTED_H__

#include "acttestfixturelist.h"

struct __ITestFixtureNode {

	struct __ITestFixtureNode* pPrev;
	struct __ITestFixtureNode* pNext;
	ITestFixture*               pData;
};


struct __ITestFixtureList
{
    ITestFixtureListVtbl         * pvt;
    uint32    m_cRef;
	int		nNodeCount; ///< number (default : 0)
	struct __ITestFixtureNode* 	lpNodeHead; ///< pointer to the node of head (default : null)
	struct __ITestFixtureNode*	lpNodeTail; ///< pointer to the node of tail(default: null)
};


ACTRESULT 
_ITestFixtureList_new(ITestFixtureList** ppobj);

void            
_ITestFixtureList_ctor(ITestFixtureList* pobj, ITestFixtureListVtbl* pvt);

void 
_ITestFixtureList_initVtbl(ITestFixtureListVtbl* pvt);

ACTRESULT 
_ITestFixtureList_init(ITestFixtureList* pobj);

uint32         
_ITestFixtureList_addRef(ITestFixtureList* pobj);

uint32          
_ITestFixtureList_release(ITestFixtureList* pobj);

void            
_ITestFixtureList_xtor(ITestFixtureList* pobj);

ACTRESULT   
_ITestFixtureList_queryInterface(ITestFixtureList* pobj, ACTCLSID clsid, void ** ppNew);

#endif /* __ACTTESTFIXTURELIST_PROTECTED_H__ */
