/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTLIST_PROTECTED_H__
#define  __ACTTESTLIST_PROTECTED_H__

#include "acttestlist.h"

#ifdef	__cplusplus
extern "C" {
#endif

struct __ITestNode {

	struct __ITestNode* pPrev;
	struct __ITestNode* pNext;
	ITest*               pData;
};


struct __ITestList
{
    ITestListVtbl         * pvt;
    uint32                  m_cRef;
	int		nNodeCount; ///< number (default : 0)
	struct __ITestNode* 	lpNodeHead; ///< pointer to the node of head (default : null)
	struct __ITestNode*	lpNodeTail; ///< pointer to the node of tail(default: null)
};


/// Construction/Destruction

    /** Allocates an empty ordered list. */
// use
//    ITestList* ITestList_New(void);    

    /** Free a TestCaseList, but don't free values if bDataDelete is false*/
//    void ITestList_Delete(ITestList* pMe, boolean bDataDelete);



ACTRESULT 
_ITestList_new(ITestList** ppobj);

void            
_ITestList_ctor(ITestList* pobj, ITestListVtbl* pvt);

void 
_ITestList_initVtbl(ITestListVtbl* pvt);

ACTRESULT 
_ITestList_init(ITestList* pobj);

uint32         
_ITestList_addRef(ITestList* pobj);

uint32          
_ITestList_release(ITestList* pobj);

void            
_ITestList_xtor(ITestList* pobj);

ACTRESULT   
_ITestList_queryInterface(ITestList* pobj, ACTCLSID clsid, void ** ppNew);

#ifdef	__cplusplus
}
#endif


#endif /*  __ACTTESTLIST_PROTECTED_H__ */
