/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTRUNNER_PROTECTED_H__
#define __ACTTESTRUNNER_PROTECTED_H__
/** 
@file acttestrunner_protected.h
*/

#include "acttestrunner.h"
#include "acttestlist.h"

struct __ITestRunner {
    ITestRunnerVtbl *pvt;
    uint32 m_cRef;
    ITestList* m_lstTest__;
};


ACTRESULT 
_ITestRunner_new(ITestRunner** ppobj);

void 
_ITestRunner_ctor(ITestRunner* pme, ITestRunnerVtbl* pvt);


void 
_ITestRunner_initVtbl(ITestRunnerVtbl* pvt);

ACTRESULT 
_ITestRunner_init(ITestRunner* pobj);

uint32 
_ITestRunner_addRef(ITestRunner* pobj);


uint32 
_ITestRunner_release(ITestRunner* pobj);


void 
_ITestRunner_xtor(ITestRunner* pme);


ACTRESULT 
_ITestRunner_queryInterface(ITestRunner* pobj, ACTCLSID clsid, void ** ppNew);


void 
_ITestRunner_start(ITestRunner* pme);


void 
_ITestRunner_addTest(ITestRunner* pme, ITest* test);


void 
_ITestRunner_runTest(ITestRunner* pMe);


void 
_ITestRunner_end(ITestRunner* pme);

#endif /* __ACTTESTRUNNER_PROTECTED_H__ */
