/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTSUITE_PROTECTED_H__
#define __ACTTESTSUITE_PROTECTED_H__

#include "acttestsuite.h"
#include "acttestlist.h"

struct __ITestSuite {
    ITestSuiteVtbl* pvt;
    uint32 m_cRef;
    char name[ACT_TEST_NAME_LENGTH];
    ITestList* m_lstTest__;
};


ACTRESULT 
_ITestSuite_new(ITestSuite** ppobj);

void 
_ITestSuite_ctor(ITestSuite* pme, ITestSuiteVtbl* pvt);



void 
_ITestSuite_initVtbl(ITestSuiteVtbl* pvt);


ACTRESULT 
_ITestSuite_init(ITestSuite* pobj, char * name);


uint32 
_ITestSuite_addRef(ITestSuite* pobj);

uint32 
_ITestSuite_release(ITestSuite* pobj);



void 
_ITestSuite_xtor(ITestSuite* pme);

ACTRESULT 
_ITestSuite_queryInterface(ITestSuite* pobj, ACTCLSID clsid, void ** ppNew);

char*    _ITestSuite_name(ITestSuite* self);
void     _ITestSuite_run(ITestSuite* self,ITestResult* result);
int      _ITestSuite_countTestCases(ITestSuite* self);
int      _ITestSuite_getChildTestCount(ITestSuite* self);
ITest*      _ITestSuite_getChildTestAt(ITestSuite* pme, int index);
ITest*      _ITestSuite_findTest(ITestSuite* pme, char *pszName);

void _ITestSuite_addTest(ITestSuite* pme, ITest* pITest);
ITest* _ITestSuite_findName(ITestSuite* self,char * pszName);

#endif /* __ACTTESTSUITE_PROTECTED_H__ */

