/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "actcommon.h"

#include "actunknown_protected.h"
#include "acttestcase_protected.h"
#include "acttestsuite_protected.h"
#include "acttestlist_protected.h"
#include "acttestresult_protected.h"
#include "acttestlistener_protected.h"
#include "acttestrunner_protected.h"
#include "acttestrepeat_protected.h"
#include "acttestfixture_protected.h"
#include "acttestcaller_protected.h"
#include "acttestfixturelist_protected.h"
#include "acttestvector_protected.h"

ACTRESULT act_createInstance(ACTCLSID clsid, void** ppv)
{
    switch(clsid)
    {
    case ACTCLSID_UNKNOWN				: 
        _IUnknown_new((IUnknown**) ppv);
        break;

    case ACTCLSID_TEST                   :
        /* nothing */
        return ACT_E_CLASSNOTSUPPORT;
        break;

    case ACTCLSID_TESTCASE               :
        _ITestCase_new((ITestCase**) ppv);
        break;

    case ACTCLSID_TESTSUITE              :
        _ITestSuite_new((ITestSuite**) ppv);
        break;

    case ACTCLSID_TESTLIST               :
        _ITestList_new((ITestList**) ppv);
        break;

    case ACTCLSID_TESTRESULT             :
        _ITestResult_new((ITestResult**) ppv);
        break;

    case ACTCLSID_TESTLISTENER            :
        _ITestListener_new((ITestListener**) ppv);
        break;

    case ACTCLSID_TESTRUNNER             :
        _ITestRunner_new((ITestRunner**) ppv);
        break;

    case ACTCLSID_TESTREPEAT             :
       _ITestRepeat_new((ITestRepeat**) ppv);
       break;

    case ACTCLSID_TESTFIXTURE            :
        _ITestFixture_new((ITestFixture**) ppv);
        break;

    case ACTCLSID_TESTCALLER             :
        _ITestCaller_new((ITestCaller**)ppv);
        break;

    case ACTCLSID_TESTFIXTURELIST        :
        _ITestFixtureList_new((ITestFixtureList**) ppv);
        break;
    
    case ACTCLSID_TESTVECTOR             :
        _ITestVec_new((ITestVec**) ppv);
        break;

    case ACTCLSID_TESTVECTORITERATOR    :
        _ITestVecIterator_new((ITestVecIterator**) ppv);
        break;

    default:
        return ACT_E_CLASSNOTSUPPORT;
    }

    return ACT_S_OK;
}
