/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/


#include "actcommon.h"
#include "acttestfixture.h"
#include "acttestfixture_protected.h"
#include "acttestfixture_private.h"

// ----


ACTRESULT 
_ITestFixture_new(ITestFixture** ppobj)
{
    ACTRESULT result;
    ITestFixture * pme;

    pme = (ITestFixture*) act_malloc(sizeof(ITestFixture) + sizeof(ITestFixtureVtbl) );

    *ppobj = NULL;

    if(!pme)
    {
        return ACT_E_NOMEMORY;
    }
    
    _ITestFixture_ctor(pme, (ITestFixtureVtbl*)(pme+1));
    result = _ITestFixture_init(pme,"", NULL);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestFixture_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (ITestFixture*)pme;
    
    return result;
    
}

void 
_ITestFixture_ctor(ITestFixture* pme, ITestFixtureVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestFixture_initVtbl(pvt);
    }    
}


void 
_ITestFixture_initVtbl(ITestFixtureVtbl* pvt)
{
    pvt->addRef = _ITestFixture_addRef;
    pvt->release = _ITestFixture_release;
    pvt->queryInterface = _ITestFixture_queryInterface;

    pvt->init = _ITestFixture_init;
    pvt->name = _ITestFixture_name;
    pvt->test = _ITestFixture_test;
}


ACTRESULT 
_ITestFixture_init(ITestFixture* pobj, char* name, PFNTEST test)
{
    ITestFixture * pme;
    pme = (ITestFixture *) pobj;

	act_strncpy(pme->name, name,ACT_TEST_NAME_LENGTH);
	pme->test = test;
    
    return ACT_S_OK;
}


uint32 
_ITestFixture_addRef(ITestFixture* pobj)
{
    ITestFixture* pme = (ITestFixture*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestFixture_release(ITestFixture* pobj)
{
    ITestFixture* pme;
    uint32 cRef;

    pme = (ITestFixture*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestFixture_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void 
_ITestFixture_xtor(ITestFixture* pme)
{
}


ACTRESULT 
_ITestFixture_queryInterface(ITestFixture* pobj, ACTCLSID clsid, void ** ppNew)
{
    ACTRESULT result;

    result = ACT_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == ACTCLSID_UNKNOWN ||clsid == ACTIID_UNKNOWN ||
        clsid == ACTCLSID_TESTFIXTURE || clsid == ACTIID_TESTFIXTURE)
    {
        *ppNew = pobj;
        _ITestFixture_addRef(pobj);
        result = ACT_S_OK;
    }
    
    return result;
}

char* _ITestFixture_name(ITestFixture* pme)
{
	return pme->name;
}

PFNTEST  _ITestFixture_test(ITestFixture* pme)
{
	return pme->test;
}


