/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "actcommon.h"
 
#include "acttestlistener_protected.h"

///////////////////////////////////////////////////////////////////////////////

ACTRESULT _ITestListener_new(ITestListener** ppobj)
{
    ACTRESULT result;
    ITestListener *pme;

    pme = act_malloc(sizeof(ITestListener)+sizeof(ITestListenerVtbl));

    if(!pme)
    {
        return ACT_E_NOMEMORY;
    }

    _ITestListener_ctor(pme, (ITestListenerVtbl*)(pme+1));    
    result = _ITestListener_init(pme);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestListener_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (ITestListener*)pme;
    
    return result;
    
}

void 
_ITestListener_ctor(ITestListener* pme, ITestListenerVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestListener_initVtbl(pvt);
    }    
}

void 
_ITestListener_initVtbl(ITestListenerVtbl* pvt)
{
    pvt->addRef = _ITestListener_addRef;
    pvt->release = _ITestListener_release;
    pvt->queryInterface = _ITestListener_queryInterface;
    pvt->startTest = (TestListenerStartTestCallBack)_ITestListener_startTest;
    pvt->endTest = (TestListenerEndTestCallBack)_ITestListener_endTest;
    pvt->addFailure = (TestListenerAddFailureCallBack)_ITestListener_addFailure;
}


ACTRESULT 
_ITestListener_init(ITestListener* pobj)
{
    ITestListener * pme;
    pme = (ITestListener *) pobj;
    
    return ACT_S_OK;
}


uint32 
_ITestListener_addRef(ITestListener* pobj)
{
    ITestListener* pme = (ITestListener*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestListener_release(ITestListener* pobj)
{
    ITestListener* pme;
    uint32 cRef;

    pme = (ITestListener*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestListener_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void 
_ITestListener_xtor(ITestListener* pme)
{
}


ACTRESULT 
_ITestListener_queryInterface(ITestListener* pobj, ACTCLSID clsid, void ** ppNew)
{
    ACTRESULT result;

    result = ACT_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == ACTCLSID_UNKNOWN ||
        clsid == ACTCLSID_TESTLISTENER)
    {
        *ppNew = pobj;
        _ITestListener_addRef(pobj);
        result = ACT_S_OK;
    }
    
    return result;
}

void _ITestListener_startTest(ITestListener* self,ITest* test)
{
    act_print(".");
}

void _ITestListener_endTest(ITestListener* self,ITest* test)
{
    
}

void _ITestListener_addFailure(ITestListener* self,ITest* test,const char* msg,int line,const char* file)
{
    act_print("\n");
    act_print(ITest_name(_act_getRootTest()));
    act_print(".");
    act_print(ITest_name(test));
    {
        char buf[16];
        act_print(" (");
        act_print(file);
        act_print(" ");
        act_itoa(line, buf, 10);
        act_print(buf);
        act_print(") ");
    }
    act_print(msg);
    act_print("\n");
}
