/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/


#include "actcommon.h"
#include "acttest.h"
#include "acttestlistener.h"
#include "acttestresult_protected.h"
///////////////////////////////////////////////////////////////////////////////
// ITestResult

ACTRESULT 
_ITestResult_new(ITestResult** ppobj)
{
    ACTRESULT result;
    ITestResult *pme;

    pme = act_malloc(sizeof(ITestResult)+sizeof(ITestResultVtbl));

    if(!pme)
    {
        return ACT_E_NOMEMORY;
    }

    _ITestResult_ctor(pme, (ITestResultVtbl*)(pme+1));    
    result = _ITestResult_init(pme,NULL);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestResult_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (ITestResult*)pme;
    
    return result;
    
}

void 
_ITestResult_ctor(ITestResult* pme, ITestResultVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestResult_initVtbl(pvt);
    }    
}


void 
_ITestResult_initVtbl(ITestResultVtbl* pvt)
{
    pvt->addRef = _ITestResult_addRef;
    pvt->release = _ITestResult_release;
    pvt->queryInterface = _ITestResult_queryInterface;

    pvt->init = _ITestResult_init;
    pvt->startTest = _ITestResult_startTest;
    pvt->endTest = _ITestResult_endTest;
    pvt->addFailure = _ITestResult_addFailure;

    pvt->getFailureCount = _ITestResult_getFailureCount;
    pvt->getRunCount = _ITestResult_getRunCount;
}

ACTRESULT 
_ITestResult_init(ITestResult* pobj, ITestListener* piTestListener)
{
    ITestResult * pme;
    pme = (ITestResult *) pobj;

	pme->runCount = 0;
	pme->failureCount = 0;	
    if(piTestListener)
    {
        pme->listener = piTestListener;
        ITestListener_addRef(piTestListener);
    }
    else
    {
        pme->listener = NULL;
    }

    
    return ACT_S_OK;
}


uint32 
_ITestResult_addRef(ITestResult* pobj)
{
    ITestResult* pme = (ITestResult*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestResult_release(ITestResult* pobj)
{
    ITestResult* pme;
    uint32 cRef;

    pme = (ITestResult*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestResult_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void 
_ITestResult_xtor(ITestResult* pme)
{
    if(pme->listener)
    {
        ITestListener_release(pme->listener);
    }
}


ACTRESULT 
_ITestResult_queryInterface(ITestResult* pobj, ACTCLSID clsid, void ** ppNew)
{
    ACTRESULT result;

    result = ACT_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == ACTCLSID_UNKNOWN ||
        clsid == ACTCLSID_TESTRESULT)
    {
        *ppNew = pobj;
        _ITestResult_addRef(pobj);
        result = ACT_S_OK;
    }
    
    return result;
}


void _ITestResult_startTest(ITestResult* pme,ITest* test)
{
	pme->runCount++;
	if (pme->listener) {
		ITestListener_startTest(pme->listener, test);
	}
}

void _ITestResult_endTest(ITestResult* pme,ITest* test)
{
	if (pme->listener) {
		ITestListener_endTest(pme->listener, test);
	}
}

void _ITestResult_addFailure(ITestResult* pme,ITest* test,const char* msg,int line,const char* file)
{
	pme->failureCount++;
	if (pme->listener) {
		ITestListener_addFailure(pme->listener, test, msg, line, file);
	}
}

int
_ITestResult_getFailureCount(ITestResult* pme)
{
    return pme->failureCount;
}

int
_ITestResult_getRunCount(ITestResult* pme)
{
    return pme->runCount;
}



