/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

/**
* @file       actunknown.c

* @brief      IUnknown interface implementation
*/

#include "actcommon.h"
#include "actunknown.h"
#include "actunknown_protected.h"
//#include "actunknown_private.h"


ACTRESULT 
_IUnknown_new(IUnknown** ppobj)
{
    ACTRESULT result;
    IUnknown* pme;

    pme = (IUnknown*) act_malloc(sizeof(IUnknown) + sizeof(IUnknownVtbl));

    *ppobj = NULL;

    if(!pme)
    {
        return ACT_E_NOMEMORY;
    }
    
    _IUnknown_ctor(pme, (IUnknownVtbl*)(pme+1));
    result = _IUnknown_init(pme);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _IUnknown_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (IUnknown*)pme;
    
    return result;
}


void 
_IUnknown_ctor(IUnknown* pobj, IUnknownVtbl* pvt)
{
    pobj->m_cRef = 1;

    if(pvt)
    {
        pobj->pvt = pvt;
        _IUnknown_initVtbl(pvt);
    }    
}


void 
_IUnknown_initVtbl(IUnknownVtbl* pvt)
{
    pvt->addRef = _IUnknown_addRef;
    pvt->release = _IUnknown_release;
    pvt->queryInterface = _IUnknown_queryInterface;
}


ACTRESULT 
_IUnknown_init(IUnknown* pobj)
{
      return ACT_S_OK;
}


uint32 
_IUnknown_addRef(IUnknown* pobj)
{
    IUnknown* pme = (IUnknown*) pobj;
    return ++pme->m_cRef;
}


uint32 
_IUnknown_release(IUnknown* pobj)
{
    IUnknown* pme;
    uint32 cRef;

    pme = (IUnknown*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _IUnknown_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void 
_IUnknown_xtor(IUnknown* pobj)
{
    
}


ACTRESULT 
_IUnknown_queryInterface(IUnknown* pobj, ACTCLSID clsid, void ** ppNew)
{
    if(clsid == ACTCLSID_UNKNOWN)
    {
        *ppNew = pobj;
        _IUnknown_addRef(pobj);
        return ACT_S_OK;
    }
    *ppNew = 0;
    
    return ACT_E_CLASSNOTSUPPORT;
}

