/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#if !defined(AFX_TESTRUNNERDLG_H__13506232_FCB5_422B_942D_8779D6402504__INCLUDED_)
#define AFX_TESTRUNNERDLG_H__13506232_FCB5_422B_942D_8779D6402504__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TestRunnerDlg.h : header file
//

/* Refer to MSDN documentation:
   mk:@MSITStore:h:\DevStudio\MSDN\98VSa\1036\vcmfc.chm::/html/_mfcnotes_tn033.htm#_mfcnotes_how_to_write_an_mfc_extension_dll
   to know how to write and use MFC extension DLL
   Can be found in the index with "mfc extension"
   =>
   Using:
   - your application must link  Multithreaded MFC DLL
   - memory allocation is done using the same heap
   - you must define the symbol _AFX_DLL
   Building:
   - you must define the symbol _AFX_DLL and _AFX_EXT
 */

#include "act.h"
#include "actTestSuite.h"
#include "acttestlistenermfc_protected.h"

#include "ActiveTest.h"
#include "MsDevCallerListCtrl.h"
#include "TestRunnerModel.h"	// Added by ClassView
#include "DynamicWindow/cdxCDynamicDialog.h"

class ProgressBar;
class TestRunnerModel;
typedef struct __ITestListenerMfc ITestListenerMfc;

/////////////////////////////////////////////////////////////////////////////
// TestRunnerDlg dialog

class TestRunnerDlg : public cdxCDynamicDialog
{
// Construction
public:
	TestRunnerDlg(TestRunnerModel *model,
                  CWnd* pParent = NULL);   // standard constructor
	virtual  ~TestRunnerDlg();

public:
// Listener funtions
	void startTest(ITestListenerMfc* self,ITest* test);
	void addFailure(ITestListenerMfc* self,ITest* test,char* msg,int line,char* file);
	void endTest(ITestListenerMfc* self,ITest* test);

// Dialog Data
	//{{AFX_DATA(TestRunnerDlg)
	enum { IDD = ACT_UNIT_TEST_RUNNER_IDD_DIALOG_TESTRUNNER };
	CEdit	m_details;
	MsDevCallerListCtrl	m_listCtrl;
	CButton	m_buttonClose;
	CButton	m_buttonStop;
	CButton	m_buttonRun;
	CButton	m_buttonBrowse;
	BOOL	m_bAutorunAtStartup;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(TestRunnerDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:


	// Generated message map functions
	//{{AFX_MSG(TestRunnerDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnRun();
	afx_msg void OnStop();
  virtual void OnOK();
	afx_msg void OnBrowseTest();
	afx_msg void OnQuitApplication();
	afx_msg void OnClose();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSelectedFailureChange(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelectTestInHistoryCombo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

//  typedef std::vector<CPPUNIT_NS::Test *> Tests;
    ProgressBar *m_testsProgress;
    ITest *m_selectedTest;
    ActiveTest *m_activeTest;
    ITestResult *m_testObserver;
//  CPPUNIT_NS::TestResultCollector *m_result;
  ITestListenerMfc* m_testListener;
  int m_testsRun;
  int m_errors;
  int m_failures;
  DWORD m_testStartTime;
  DWORD m_testEndTime;
  static const CString ms_cppunitKey;
  HACCEL m_hAccelerator;
  bool m_bIsRunning;
  TestRunnerModel *m_model;
  CImageList m_errorListBitmap;
  CFont m_fixedSizeFont;

  enum ErrorTypeBitmaps
  {
    errorTypeFailure =0,
    errorTypeError
  };

	void addListEntry(ITest *test, char *msg, int line, char *file);
	void beIdle();
	void beRunning();
	void beRunDisabled();
	void reset();
	void freeState();
	void updateCountsDisplay();

	CComboBox * getHistoryCombo();
	void loadSettings();
	void saveSettings();
	TestRunnerModel & model();
	void updateHistoryCombo();
	void displayFailureDetailsFor( unsigned int failureIndex );

	CRect getItemWindowRect( unsigned int itemId );
	CRect getItemClientRect( unsigned int itemId );

	virtual void initializeLayout();
	void updateListColumnSize();
	void initializeFixedSizeFont();


private:
    TestRunnerModel::Settings m_settings;

  /// do all initialization, that is usually done in the constructor, so that the
  /// code is not duplicated in the two constructors
	void TestRunnerDlg::init(TestRunnerModel *model);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TESTRUNNERDLG_H__13506232_FCB5_422B_942D_8779D6402504__INCLUDED_)
