/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "act.h"
#include "actTests.h"
#include "actMockTestCase.h"

#ifdef ACT_TESTREPEAT_TESTS

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testRepeatedOnce(void)
{
    ITestRepeat* pTestRepeat;
    ITestResult* pTestResult;
    
    ACT_TESTRESULT_NEW(pTestResult,NULL);
    ACT_TESTREPEAT_NEW(pTestRepeat, (ITest*)actMockTestCase_case(),1);

    ITest_run((ITest*)pTestRepeat, pTestResult);
    
    ACT_TEST_ASSERT_EQUAL_INT(1, ITestResult_getRunCount(pTestResult));
    ACT_TEST_ASSERT_EQUAL_INT(1, ITest_countTestCases((ITest*) pTestRepeat));

    ACT_TESTREPEAT_DELETE(pTestRepeat);
    ACT_TESTRESULT_DELETE(pTestResult);
}

static void testRepeatedMoreThanOnce(void)
{
    ITestRepeat* pTestRepeat;
    ITestResult* pTestResult;
    
    ACT_TESTRESULT_NEW(pTestResult,NULL);
    ACT_TESTREPEAT_NEW(pTestRepeat, (ITest*)actMockTestCase_case(),100);

    ITest_run((ITest*)pTestRepeat, pTestResult);
    
    ACT_TEST_ASSERT_EQUAL_INT(100, ITestResult_getRunCount(pTestResult));
    ACT_TEST_ASSERT_EQUAL_INT(100, ITest_countTestCases((ITest*) pTestRepeat));

    ACT_TESTREPEAT_DELETE(pTestRepeat);
    ACT_TESTRESULT_DELETE(pTestResult);
}

static void testRepeatedZero(void)
{
    ITestRepeat* pTestRepeat;
    ITestResult* pTestResult;
    
    ACT_TESTRESULT_NEW(pTestResult,NULL);
    ACT_TESTREPEAT_NEW(pTestRepeat, (ITest*)actMockTestCase_case(),0);

    ITest_run((ITest*)pTestRepeat, pTestResult);
    
    ACT_TEST_ASSERT_EQUAL_INT(0, ITestResult_getRunCount(pTestResult));
    ACT_TEST_ASSERT_EQUAL_INT(0, ITest_countTestCases((ITest*) pTestRepeat));

    ACT_TESTREPEAT_DELETE(pTestRepeat);
    ACT_TESTRESULT_DELETE(pTestResult); 
}

ITest* TestRepeatTest_tests(void)
{
    ITestCaller* pTestRepeatTest;

    ACT_TESTCALLER_NEW(pTestRepeatTest,"RepeatedTestTest", setUp, tearDown);

        ACT_ADD_FIXTURE(pTestRepeatTest,"testRepeatedOnce",testRepeatedOnce);
        ACT_ADD_FIXTURE(pTestRepeatTest,"testRepeatedMoreThanOnce",testRepeatedMoreThanOnce);
        ACT_ADD_FIXTURE(pTestRepeatTest,"testRepeatedZero",testRepeatedZero);
    
    return (ITest*)pTestRepeatTest;
}

#endif // def ACT_TESTREPEAT_TESTS
