/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "act.h"
#include "actTests.h"

#ifdef ACT_TESTRESULT_TESTS

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testTestResult_result(void)
{
    ITestResult* pResult;

    ACT_TESTRESULT_NEW(pResult, NULL);
    
    ACT_TEST_ASSERT_EQUAL_INT(0, ITestResult_getRunCount(pResult));
    ACT_TEST_ASSERT_EQUAL_INT(0, ITestResult_getFailureCount(pResult));

    ACT_TESTRESULT_DELETE(pResult);
}

static void testTestResult_startTest(void)
{
    ITestResult* pResult;

    ACT_TESTRESULT_NEW(pResult, NULL);

    ITestResult_startTest(pResult, NULL);
    
    ACT_TEST_ASSERT_EQUAL_INT(1, ITestResult_getRunCount(pResult));
    ACT_TEST_ASSERT_EQUAL_INT(0, ITestResult_getFailureCount(pResult));

    ACT_TESTRESULT_DELETE(pResult);
}

static void testTestResult_endTest(void)
{
    ITestResult* pResult;

    ACT_TESTRESULT_NEW(pResult, NULL);

    ITestResult_endTest(pResult, NULL);
    
    ACT_TEST_ASSERT_EQUAL_INT(0, ITestResult_getRunCount(pResult));
    ACT_TEST_ASSERT_EQUAL_INT(0, ITestResult_getFailureCount(pResult));

    ACT_TESTRESULT_DELETE(pResult);
}

static void testTestResult_addFailure(void)
{
    ITestResult* pResult;

    ACT_TESTRESULT_NEW(pResult, NULL);

    ITestResult_addFailure(pResult,NULL,"",0,"");
    
    ACT_TEST_ASSERT_EQUAL_INT(0, ITestResult_getRunCount(pResult));
    ACT_TEST_ASSERT_EQUAL_INT(1, ITestResult_getFailureCount(pResult));

    ACT_TESTRESULT_DELETE(pResult);
}

ITest* TestResultTest_tests(void)
{
    ITestCaller* pTestResultTest;
    ACT_TESTCALLER_NEW( pTestResultTest,"TestResultTest",setUp,tearDown);
    
        ACT_ADD_FIXTURE(pTestResultTest,"testTestResult_result",testTestResult_result);
        ACT_ADD_FIXTURE(pTestResultTest,"testTestResult_startTest",testTestResult_startTest);
        ACT_ADD_FIXTURE(pTestResultTest,"testTestResult_endTest",testTestResult_endTest);
        ACT_ADD_FIXTURE(pTestResultTest,"testTestResult_addFailure",testTestResult_addFailure);
    
    return (ITest*)pTestResultTest;
}
#endif // def ACT_TESTRESULT_TESTS
