/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "act.h"
#include "actTests.h"

#ifdef ACT_STDLIB_TESTS
extern ITest* StdLibTest_tests(void);
#endif

#ifdef ACT_ASSERT_TESTS
extern ITest* AssertTest_tests(void);
#endif

#ifdef ACT_TESTCASE_TESTS
extern ITest* TestCaseTest_tests(void);
#endif

#ifdef ACT_TESTRESULT_TESTS
extern ITest* TestResultTest_tests(void);
#endif

#ifdef ACT_TESTCALLER_TESTS
extern ITest* TestCallerTest_tests(void);
#endif

#ifdef ACT_TESTREPEAT_TESTS
extern ITest* TestRepeatTest_tests(void);
#endif

#ifdef ACT_UNKNOWN_TESTS
extern ITest* UnknownTest_tests(void);
#endif

int main  (int argc, const char* argv[])
{
    ITestRunner* pTestRunner;

    ACT_TESTRUNNER_NEW(pTestRunner);

    ITestRunner_start(pTestRunner);

#ifdef ACT_STDLIB_TESTS
		ITestRunner_addTest(pTestRunner,StdLibTest_tests());
#endif
#ifdef ACT_ASSERT_TESTS
		ITestRunner_addTest(pTestRunner,AssertTest_tests());
#endif
#ifdef ACT_TESTCASE_TESTS
		ITestRunner_addTest(pTestRunner,TestCaseTest_tests());
#endif
#ifdef ACT_TESTRESULT_TESTS
		ITestRunner_addTest(pTestRunner,TestResultTest_tests());
#endif
#ifdef ACT_TESTCALLER_TESTS
		ITestRunner_addTest(pTestRunner,TestCallerTest_tests());
#endif
#ifdef ACT_TESTREPEAT_TESTS
		ITestRunner_addTest(pTestRunner,TestRepeatTest_tests());
#endif
#ifdef ACT_UNKNOWN_TESTS
		ITestRunner_addTest(pTestRunner,UnknownTest_tests());
#endif
        ITestRunner_runTest(pTestRunner);

	ITestRunner_end(pTestRunner);

    ACT_TESTRUNNER_DELETE(pTestRunner);
    return 0;
}
