/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import org.springframework.aop.ClassFilter;

public abstract class ClassFilters {
    public static ClassFilter union(ClassFilter a, ClassFilter b) {
        return new UnionClassFilter(new ClassFilter[]{a, b});
    }

    public static ClassFilter intersection(ClassFilter a, ClassFilter b) {
        return new IntersectionClassFilter(new ClassFilter[]{a, b});
    }

    private static class IntersectionClassFilter
    implements ClassFilter,
    Serializable {
        private ClassFilter[] filters;

        public IntersectionClassFilter(ClassFilter[] filters) {
            this.filters = filters;
        }

        public boolean matches(Class clazz) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].matches(clazz)) continue;
                return false;
            }
            return true;
        }
    }

    private static class UnionClassFilter
    implements ClassFilter,
    Serializable {
        private ClassFilter[] filters;

        public UnionClassFilter(ClassFilter[] filters) {
            this.filters = filters;
        }

        public boolean matches(Class clazz) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].matches(clazz)) continue;
                return true;
            }
            return false;
        }
    }
}

