/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class UrlResource
extends AbstractResource {
    private final URL url;
    private final URL cleanedUrl;

    public UrlResource(URL url) {
        Assert.notNull(url, "url is required");
        this.url = url;
        this.cleanedUrl = this.getCleanedUrl(this.url, url.toString());
    }

    public UrlResource(String path) throws MalformedURLException {
        Assert.notNull(path, "path is required");
        this.url = new URL(path);
        this.cleanedUrl = this.getCleanedUrl(this.url, path);
    }

    private URL getCleanedUrl(URL originalUrl, String originalPath) {
        try {
            return new URL(StringUtils.cleanPath(originalPath));
        }
        catch (MalformedURLException ex) {
            return originalUrl;
        }
    }

    public InputStream getInputStream() throws IOException {
        URLConnection con = this.url.openConnection();
        con.setUseCaches(false);
        return con.getInputStream();
    }

    public URL getURL() throws IOException {
        return this.url;
    }

    public File getFile() throws IOException {
        return ResourceUtils.getFile(this.url, this.getDescription());
    }

    public Resource createRelative(String relativePath) throws MalformedURLException {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return new UrlResource(new URL(this.url, relativePath));
    }

    public String getFilename() {
        return new File(this.url.getFile()).getName();
    }

    public String getDescription() {
        return "URL [" + this.url + "]";
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof UrlResource && this.cleanedUrl.equals(((UrlResource)obj).cleanedUrl);
    }

    public int hashCode() {
        return this.cleanedUrl.hashCode();
    }
}

