/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    private static List getSubList(Iterator iterator, int startIndex, int numberOfItems) {
        ArrayList croppedList = new ArrayList(numberOfItems);
        int skippedRecordCount = 0;
        int copiedRecordCount = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (++skippedRecordCount <= startIndex) continue;
            croppedList.add(object);
            if (numberOfItems != 0 && ++copiedRecordCount >= numberOfItems) break;
        }
        return croppedList;
    }

    public static List getListFromObject(Object iterableObject, int startIndex, int numberOfItems) {
        if (iterableObject instanceof List) {
            int lastRecordExclusive;
            List list = (List)iterableObject;
            int n = lastRecordExclusive = numberOfItems <= 0 ? list.size() : startIndex + numberOfItems;
            if (lastRecordExclusive > list.size()) {
                lastRecordExclusive = list.size();
            }
            if (startIndex < list.size()) {
                return list.subList(startIndex, lastRecordExclusive);
            }
        }
        Iterator iterator = IteratorUtils.getIterator((Object)iterableObject);
        return CollectionUtil.getSubList(iterator, startIndex, numberOfItems);
    }
}

